import {React, PureComponent, B} from '../../base';

import noop from '../../../lib/noop';
import once from '../../../lib/once';

const b = B('RadioButton');

export default class RadioButton extends PureComponent {
    state = {
        checked: this.props.checked,
    };

    componentWillReceiveProps(props) {
        this.setState({
            checked: props.checked,
        });
    }

    onChange = e => {
        this.setState({checked: true});
        this.props.onChange(e, {value: e.target.value});
    };

    onFocus = e => {
        this.setState({focused: true});
        this.props.onFocus(e);
    };

    onBlur = e => {
        this.setState({focused: false});
        this.props.onBlur(e);
    };

    onMouseDown = () => {
        this.setState({pressed: true});
        once(document, 'mouseup', this.onMouseUp);
    };

    onMouseUp = () => {
        this.setState({pressed: false});
    };

    onMouseEnter = e => {
        const {value, disabled} = this.props;

        this.props.onMouseEnter(e, {value, disabled});
    };

    onMouseLeave = e => {
        const {value, disabled} = this.props;

        this.props.onMouseLeave(e, {value, disabled});
    };

    render() {
        const {name, value, label, disabled} = this.props;
        const state = this.state;

        return (
            <label
                className={b({
                    ...state,
                    disabled,
                })}
                onMouseDown={this.onMouseDown}
                onMouseEnter={this.onMouseEnter}
                onMouseLeave={this.onMouseLeave}
            >
                <input
                    className={b('input', {disabled})}
                    type="radio"
                    name={name}
                    value={value}
                    disabled={disabled}
                    checked={state.checked}
                    onChange={this.onChange}
                    onFocus={this.onFocus}
                    onBlur={this.onBlur}
                />

                <span className={b('buttonLable')}>{label}</span>
            </label>
        );
    }
}

RadioButton.defaultProps = {
    onFocus: noop,
    onBlur: noop,
    onMouseEnter: noop,
    onMouseLeave: noop,
};
