import {React, PureComponent, mix} from '../../base';

import RadioButton from '../RadioButton';

const b = 'RadioGroup';

export default class RadioGroup extends PureComponent {
    render() {
        const {
            name,
            value,
            buttons,
            disabled,

            onBlur,
            onFocus,
            onChange,
            onMouseEnter,
            onMouseLeave,

            className,
        } = this.props;

        return (
            <span className={mix(b, className)}>
                {buttons.map(button => (
                    <RadioButton
                        key={button.value}
                        disabled={disabled || button.disabled}
                        {...button}
                        name={name}
                        checked={button.value === value}
                        onBlur={onBlur}
                        onFocus={onFocus}
                        onChange={onChange}
                        onMouseEnter={onMouseEnter}
                        onMouseLeave={onMouseLeave}
                    />
                ))}
            </span>
        );
    }
}
