import {React, mix} from '../../../base';

import {connect} from 'react-redux';

import TooltipComponent from '../../../_mixins/TooltipComponent';

import keyset from '../../../../i18n/segment';

const b = 'DynamicPricing';

class DynamicPricing extends TooltipComponent {
    render() {
        const {hint, className} = this.props;

        return (
            <abbr
                className={mix(b, className)}
                aria-label={hint}
                onMouseEnter={this.onMouseEnter}
                onMouseLeave={this.onMouseLeave}
            >
                {keyset('dynamic-pricing')}
            </abbr>
        );
    }
}

DynamicPricing.defaultProps = {
    ...TooltipComponent.defaultProps,
};

export default connect()(DynamicPricing);
