import {React, PropTypes, B, PureComponent} from '../../../base';

import {TRANSPORT_CITY_TRANSPORT_TYPES} from '../../../../lib/transportType';
import {STATIONS_GROUP_PROPTYPE} from '../../../../reducers/propTypes/stationsGroup';

import Tld from '../../../../interfaces/Tld';
import Platform from '../../../../interfaces/Platform';

import insertMarkupIntoKey from '../../../../i18n/_utils/insertMarkupIntoKey';
import buildTransportCityUrl from '../../../../lib/url/transportCityUrl';
import buildTransportUrl from '../../../../lib/url/transportUrl';

import Link from '../../../Link';

import disclaimersKeyset from '../../../../i18n/disclaimers';

const b = B('DescriptionHome');
const isMobile = process.env.PLATFORM === Platform.mobile;

const COUNTRIES_WITH_LINKS = [Tld.ru, Tld.by, Tld.kz];

export default class DescriptionHome extends PureComponent {
    static propTypes = {
        currentSettlement: PropTypes.object.isRequired,
        stationsGroup: STATIONS_GROUP_PROPTYPE.isRequired,
        isCity: PropTypes.bool,
    };

    render() {
        const {
            stationsGroup,
            tld,
            isCity,
            currentSettlement: {slug},
        } = this.props;

        const stationsCountByTransportType = {};
        const transportTypes = {};

        if (COUNTRIES_WITH_LINKS.includes(tld)) {
            stationsGroup.forEach(group => {
                const {
                    t_type: groupTransportType,
                    stations: {length: stationsCount},
                } = group;

                stationsCountByTransportType[groupTransportType] =
                    stationsCount;
            });

            TRANSPORT_CITY_TRANSPORT_TYPES.forEach(transportType => {
                const stationsCountForType =
                    stationsCountByTransportType[transportType];
                const url =
                    stationsCountForType > 1
                        ? buildTransportCityUrl({
                              transportType,
                              slug,
                          })
                        : buildTransportUrl({transportType});

                transportTypes[transportType] = (
                    <Link key={transportType} href={url}>
                        {disclaimersKeyset(`homepage-content-${transportType}`)}
                    </Link>
                );
            });
        } else {
            TRANSPORT_CITY_TRANSPORT_TYPES.forEach(transportType => {
                transportTypes[transportType] = disclaimersKeyset(
                    `homepage-content-${transportType}`,
                );
            });
        }

        const content = insertMarkupIntoKey(
            disclaimersKeyset,
            isCity ? 'citypage-content' : 'homepage-content',
            transportTypes,
        );

        return (
            <div className={b({isMobile})}>
                <h2 className={b('announce')}>
                    {disclaimersKeyset('homepage-announce')}
                </h2>

                <div className={b('content')}>{content}</div>
            </div>
        );
    }
}
