import {React, ConstantComponent, B} from '../../../../base';

import {
    GOOGLE_PLAY_URL,
    APP_STORE_URL,
} from '../../../../../lib/constants/appUrls';

import Link from '../../../../Link';

const b = B('AppLinks');

export default class AppLinks extends ConstantComponent {
    render() {
        return (
            <div className={b()}>
                <Link
                    className={b('link', {type: 'googleplay'})}
                    href={GOOGLE_PLAY_URL}
                    target="_blank"
                    rel="nofollow"
                >
                    <img
                        src={`${process.env.IMAGES_PATH}/googleplay.svg`}
                        alt="google-play"
                    />
                </Link>

                <Link
                    className={b('link', {type: 'appstore'})}
                    href={APP_STORE_URL}
                    target="_blank"
                    rel="nofollow"
                >
                    <img
                        src={`${process.env.IMAGES_PATH}/appStoreApple.svg`}
                        alt="app-store"
                    />
                </Link>
            </div>
        );
    }
}
