import React, {memo} from 'react';
import B from 'bem-cn-lite';

import Link from '../../../../Link';

const b = B('Promotion');

interface IPromotionProps {
    type: string;
    icon: React.ReactElement;
    title: string;
    url: string;
    children: React.ReactElement;
}

function Promotion({
    type,
    icon,
    title,
    url,
    children,
}: IPromotionProps): React.ReactElement {
    return (
        <div className={b({type})}>
            <Link className={b('link')} href={url} rel="nofollow" />

            <div className={b('icon')}>{icon}</div>

            <h3 className={b('title')}>{title}</h3>

            <div className={b('content')}>{children}</div>
        </div>
    );
}

export default memo(Promotion);
