import React, {memo} from 'react';
import B from 'bem-cn-lite';

import {PROMOTIONS} from '../../../../lib/constants/homepageBlocks';

import IStateSeoQueryParams from '../../../../interfaces/state/IStateSeoQueryParams';
import IconGlyph from '../../../../interfaces/components/IconGlyph';

import shouldShowBlockForCountry from '../../../../lib/shouldShowBlockForCountry';
import applyUtm from '../../../../lib/url/applyUtm';
import useSelector from '../../../useSelector';
import getTravelDomain from '../../../../lib/url/getTravelDomain';

import Icon from '../../../Icon/Icon';
import Promotion from './Promotion';
import AppLinks from './AppLinks';

import keyset from '../../../../i18n/promotions-list';

const b = B('Promotions');

const MOBILE_URL = 'https://mobile.yandex.ru/apps/rasp';

interface IGetTravelPromotionUrl {
    isProduction: boolean;
    service: string;

    seoQueryParams?: IStateSeoQueryParams;
    clientId?: string;
    utmMedium?: string;
}

function getTravelPromotionUrl({
    isProduction,
    service,

    seoQueryParams,
    clientId,
    utmMedium,
}: IGetTravelPromotionUrl): string {
    return applyUtm(
        `${getTravelDomain({isProduction})}/${service}`,
        seoQueryParams,
        clientId,
        utmMedium,
    );
}

export default memo(Promotions);

function Promotions(): React.ReactElement | null {
    const tld = useSelector(state => state.tld);
    const seoQueryParams = useSelector(state => state.seoQueryParams);
    const clientId = useSelector(state => state.user.clientId);
    const isProduction = useSelector(state => state.environment.production);

    if (!shouldShowBlockForCountry(PROMOTIONS, tld)) {
        return null;
    }

    return (
        <div className={b()}>
            <Promotion
                type="suburban"
                icon={
                    <img
                        className={b('icon')}
                        src={`${process.env.IMAGES_PATH}/suburban-colored.svg`}
                        alt="suburban-icon"
                    />
                }
                title={keyset('title-suburban')}
                url={MOBILE_URL}
            >
                <AppLinks />
            </Promotion>

            <Promotion
                type="bus"
                icon={
                    <img
                        className={b('icon')}
                        src={`${process.env.IMAGES_PATH}/bus-colored.svg`}
                        alt="bus-icon"
                    />
                }
                title={keyset('title-bus')}
                url={getTravelPromotionUrl({
                    isProduction,
                    service: 'buses',
                    seoQueryParams,
                    clientId,
                    utmMedium: 'main_page',
                })}
            >
                <div>{keyset('text-bus')}</div>
            </Promotion>

            <Promotion
                type="avia"
                icon={
                    <Icon className={b('icon')} glyph={IconGlyph.aviaColored} />
                }
                title={keyset('title-avia')}
                url={getTravelPromotionUrl({
                    isProduction,
                    service: 'avia',
                    seoQueryParams,
                    clientId,
                    utmMedium: 'main',
                })}
            >
                <div>{keyset('text-avia')}</div>
            </Promotion>
        </div>
    );
}
