import React from 'react';
import B from 'bem-cn-lite';

import {HOME_PAGE_NAME} from '../../../../../routes';

import Platform from '../../../../../interfaces/Platform';
import IStatePage from '../../../../../interfaces/state/IStatePage';
import IStateFlags from '../../../../../interfaces/state/flags/IStateFlags';
import {IWithClassName} from '../../../../../interfaces/components/IWithClassName';

import Direct from '../../../../Direct/Direct';

const b = B('DirectInMainPageOnDesktop');

const isMobile = process.env.PLATFORM === Platform.mobile;

const DIRECT_ID_DESKTOP_IN_FOOTER = 'R-I-94177-22';

interface IDirectInMainPageOnDesktopProps extends IWithClassName {
    page: IStatePage;
    flags: IStateFlags;
}

const DirectInMainPageOnDesktop: React.FC<IDirectInMainPageOnDesktopProps> =
    props => {
        const {page, flags, className} = props;
        const {idDirectHomeFooterDesktop} = flags;

        const pageType = page.fetching || page.current;

        if (isMobile || pageType !== HOME_PAGE_NAME) {
            return null;
        }

        const blockId =
            idDirectHomeFooterDesktop || DIRECT_ID_DESKTOP_IN_FOOTER;

        return (
            <div className={b({}, className)}>
                <Direct blockId={blockId} />
            </div>
        );
    };

export default DirectInMainPageOnDesktop;
