import React, {memo} from 'react';
import B from 'bem-cn-lite';

import useSelector from '../../useSelector';
import {useFlags} from '../../../hooks/useFlags';

import Promotions from './Promotions';
import DescriptionHome from './DescriptionHome';
import DirectInMainPageOnDesktop from './components/DirectInMainPageOnDesktop';

const b = B('HomeLayout');

export default memo(HomeLayout);

interface IHomeLayout {
    children: React.ReactElement;
}

function HomeLayout({children}: IHomeLayout): React.ReactElement {
    const tld = useSelector(state => state.tld);
    const home = useSelector(state => state.home);
    const flags = useFlags();
    const stationsGroup = useSelector(state => state.stationsGroup);
    const page = useSelector(state => state.page);
    const currentSettlement = useSelector(state => state.currentSettlement);
    const {isCity} = home;

    return (
        <div className={b()}>
            {children}

            <Promotions />

            <DescriptionHome
                currentSettlement={currentSettlement}
                stationsGroup={stationsGroup}
                isCity={isCity}
                tld={tld}
            />

            <DirectInMainPageOnDesktop page={page} flags={flags} />
        </div>
    );
}
