import React from 'react';
import B from 'bem-cn-lite';

import IStateFlags from '../../../interfaces/state/flags/IStateFlags';
import IStateSearch from '../../../interfaces/state/search/IStateSearch';

import Overlay from '../../Overlay/Overlay';
import SearchPageSidebar from '../../SearchPageSidebar';

interface ISearchLayoutProps {
    flags: IStateFlags;
    search: IStateSearch;
    isFetching: boolean;
    hasDescription: boolean;
}

const b = B('SearchLayout');

const SearchLayout: React.FC<ISearchLayoutProps> = ({
    search,
    isFetching,
    hasDescription,
    flags,
    children,
}) => (
    <div
        className={b({
            hasDescription: hasDescription && !isFetching,
            platform: process.env.PLATFORM,
        })}
    >
        <div className={b('content')}>
            {!isFetching ? children : null}

            <Overlay className={b('overlay')} isVisible={isFetching} />
        </div>

        {process.env.PLATFORM === 'desktop' && (
            <SearchPageSidebar teasers={search.teasers} flags={flags} />
        )}
    </div>
);

export default SearchLayout;
