import React, {memo, PropsWithChildren} from 'react';
import B from 'bem-cn-lite';

import StationSubtype from '../../../interfaces/state/station/StationSubtype';

import Direct from '../../Direct/Direct';

const b = B('StationLayout');

const subtypeToDirectId = {
    [StationSubtype.suburban]: 'R-I-94177-45',
    [StationSubtype.train]: 'R-I-94177-43',
    [StationSubtype.plane]: 'R-I-94177-44',
    [StationSubtype.tablo]: 'R-I-94177-79',
};

// Нужно будет задать отдельный ИД-шник если захотим считать
const DEFAULT_DIRECT_ID = 'R-I-94177-43';

interface IStationLayoutProps {
    subtype?: StationSubtype;
}

function StationLayout({
    subtype,
    children,
}: PropsWithChildren<IStationLayoutProps>): React.ReactElement {
    const blockId =
        (subtype && subtypeToDirectId[subtype]) || DEFAULT_DIRECT_ID;

    return (
        <div className={b()}>
            <Direct
                className={b('topDirect')}
                blockId={blockId}
                updateIfLoadedAnotherPage={false}
            />

            <div className={b('content')}>{children}</div>
        </div>
    );
}

export default memo(StationLayout);
