import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import Direct from '../../Direct/Direct';
import {ThreadLayoutContextProvider} from './ThreadLayoutContext';

const b = B('ThreadLayout');

interface IThreadLayoutProps {}

interface IThreadLayoutState {
    marginBottom: number | undefined;
    topDirectRendered: boolean;
}

export default class ThreadLayout extends PureComponent<
    IThreadLayoutProps,
    IThreadLayoutState
> {
    state = {
        marginBottom: undefined,
        topDirectRendered: false,
    };

    // eslint-disable-next-line react/sort-comp
    setMarginBottom = (size: number): void => {
        this.setState({
            marginBottom: size,
        });
    };

    // eslint-disable-next-line react/sort-comp
    contextValue = {
        setMarginBottom: this.setMarginBottom,
    };

    onRenderTopDirect = (): void => {
        this.setState({
            topDirectRendered: true,
        });
    };

    render(): React.ReactElement {
        const {children} = this.props;
        const {topDirectRendered, marginBottom} = this.state;

        return (
            <ThreadLayoutContextProvider value={this.contextValue}>
                <div className={b()} style={{marginBottom}}>
                    <div
                        className={b('topDirect', {
                            rendered: topDirectRendered,
                        })}
                    >
                        <Direct
                            blockId="R-I-94177-32"
                            onRender={this.onRenderTopDirect}
                        />
                    </div>

                    <div className={b('content')}>{children}</div>

                    <Direct
                        blockId="R-I-94177-30"
                        className={b('bottomDirect')}
                    />
                </div>
            </ThreadLayoutContextProvider>
        );
    }
}
