import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import IStateFlags from '../../../interfaces/state/flags/IStateFlags';

import {ThreadLayoutContextProvider} from './ThreadLayoutContext';
import Direct from '../../Direct/Direct';

const b = B('ThreadLayout');

const DIRECT_ID = 'R-I-239082-65';
const SMARTBANNER_ID = 'Y-A-341252-1';
const DIRECT_ID_EVERLASTING_EXPERIMENT = 'R-I-239082-34';

interface IThreadLayoutProps {
    flags: IStateFlags;
}

interface IThreadLayoutState {
    marginBottom: number | undefined;
}

export default class ThreadLayout extends PureComponent<
    IThreadLayoutProps,
    IThreadLayoutState
> {
    state = {
        marginBottom: undefined,
    };

    // eslint-disable-next-line react/sort-comp
    setMarginBottom = (size: number): void => {
        this.setState({
            marginBottom: size,
        });
    };

    // eslint-disable-next-line react/sort-comp
    contextValue = {
        setMarginBottom: this.setMarginBottom,
    };

    getDirectId(): string {
        const {flags} = this.props;
        const {__everlastingThreadTouchExperiment} = flags;

        return __everlastingThreadTouchExperiment
            ? DIRECT_ID_EVERLASTING_EXPERIMENT
            : DIRECT_ID;
    }

    render(): React.ReactElement {
        const {children} = this.props;
        const {marginBottom} = this.state;

        return (
            <ThreadLayoutContextProvider value={this.contextValue}>
                <div className={b()} style={{marginBottom}}>
                    <div className={b('content')}>{children}</div>

                    <Direct
                        blockId={this.getDirectId()}
                        className={b('bottomDirect')}
                    />

                    <Direct
                        blockId={SMARTBANNER_ID}
                        format="popup"
                        position="relative"
                        className={b('smartbanner')}
                    />
                </div>
            </ThreadLayoutContextProvider>
        );
    }
}
