import {React, PureComponent, B, bindMethods} from '../../base';

import {updateSorting} from '../../../actions/search/sorting';
import {
    getSortFieldOptions,
    getSortDirectionOptions,
} from '../../../lib/sort/utils';
import {reachGoal} from '../../../lib/yaMetrika';

import Button from '../../Button/Button';
import Select from '../../basic/Select/Select';

const b = B('SearchSorting');

export default class SearchSorting extends PureComponent {
    constructor(props) {
        super(props);
        bindMethods(this, [
            'onSortClick',
            'onFieldChange',
            'onDirectionChange',
        ]);
    }

    onFieldChange(option) {
        const sort = {
            by: option.value,
            reverse: false,
        };

        this.props.dispatch(updateSorting(sort));
    }

    onSortClick() {
        reachGoal('sorting_title_click');
    }

    onDirectionChange(e) {
        e.preventDefault();
        const reverse = !this.props.sort.reverse;
        const sort = {
            by: this.props.sort.by,
            reverse,
        };

        this.props.dispatch(updateSorting(sort));
        reachGoal('sorting_order_click');
    }

    render() {
        const {sort} = this.props;
        const directionOptions = getSortDirectionOptions(sort.by);
        const sortOptions = getSortFieldOptions();
        const sortValue = sortOptions.find(({value}) => value === sort.by);

        return (
            <div className={b()}>
                <Select
                    className={b('field')}
                    options={sortOptions}
                    value={sortValue}
                    onOpen={this.onSortClick}
                    onChange={this.onFieldChange}
                />

                <Button
                    type="button"
                    className={b('direction')}
                    onClick={this.onDirectionChange}
                >
                    {sort.reverse
                        ? directionOptions[1].title
                        : directionOptions[0].title}
                </Button>
            </div>
        );
    }
}
