import {React, PureComponent, B, bindMethods} from '../../base';

import noop from '../../../lib/noop';
import {reachGoal} from '../../../lib/yaMetrika';
import {
    ASCENDING_SORT,
    DESCENDING_SORT,
    getSortFieldOptions,
    getSortDirectionOptions,
} from '../../../lib/sort/utils';

import Select from '../../basic/Select/Select';

const b = B('SearchSorting');

export default class SearchSorting extends PureComponent {
    static defaultProps = {
        onChange: noop,
    };

    constructor(props) {
        super(props);
        bindMethods(this, ['onTypeChange', 'onDirectionChange']);
    }

    onSortTypeClick() {
        reachGoal('sorting_title_click');
    }

    onSortDirectionClick() {
        reachGoal('sorting_order_click');
    }

    onTypeChange(option) {
        this.props.onChange({
            by: option.value,
            reverse: false,
        });
    }

    onDirectionChange(option) {
        this.props.onChange({
            by: this.props.sort.by,
            reverse: option.value === DESCENDING_SORT,
        });
    }

    render() {
        const {sort} = this.props;
        const typeOptions = getSortFieldOptions();
        const typeValue = typeOptions.find(({value}) => value === sort.by);
        const directionOptions = getSortDirectionOptions(sort.by);
        const valueOfDirection = sort.reverse
            ? DESCENDING_SORT
            : ASCENDING_SORT;
        const directionValue = directionOptions.find(
            ({value}) => value === valueOfDirection,
        );

        return (
            <div className={b()}>
                <Select
                    className={b('type')}
                    options={typeOptions}
                    value={typeValue}
                    listItemSize="big"
                    onOpen={this.onSortTypeClick}
                    onChange={this.onTypeChange}
                />

                <Select
                    className={b('direction')}
                    options={directionOptions}
                    value={directionValue}
                    listItemSize="big"
                    onOpen={this.onSortDirectionClick}
                    onChange={this.onDirectionChange}
                />
            </div>
        );
    }
}
