import {React, PureComponent} from '../../base';

import noop from '../../../lib/noop';
import {getToday, getOrderRange} from '../../../lib/date/utils';
import {getMonthsByMask} from '../../../lib/date/mask';
import isCppk from '../../../lib/segments/isCppk';
import {getAllDaysLinkComponent} from '../../../lib/search/getAllDaysLinkComponent';

import Calendar from '../../Calendar/Calendar';

export default class SegmentCalendar extends PureComponent {
    static defaultProps = {
        onClose: noop,
        onChange: noop,
    };

    render() {
        const {
            context,
            segment,
            tariffClassKeys,

            opened,
            onClose,
            onChange,

            flags,
            language,
            currencies,
            nowMoment,
        } = this.props;
        const {time, when} = context;
        const {runDays, transport, salesLimitInDays, trainPurchaseNumbers} =
            segment;

        const today = getToday(time);
        const months = getMonthsByMask({
            mask: runDays,
            timezone: time.timezone,
        });
        const orderRange = getOrderRange(
            today,
            transport.code,
            salesLimitInDays,
            isCppk(segment),
        );

        const DayComponent = getAllDaysLinkComponent({
            transportType: transport.code,
            trainPurchaseNumbers,
        });

        return (
            <Calendar
                time={time}
                value={when}
                months={months}
                showToolbar={false}
                opened={opened}
                DayComponent={DayComponent}
                nowMoment={nowMoment}
                segment={segment}
                context={context}
                orderRange={orderRange}
                tariffClassKeys={tariffClassKeys}
                flags={flags}
                language={language}
                currencies={currencies}
                onClose={onClose}
                onChange={onChange}
            />
        );
    }
}
