import {React, Component, B} from '../../base';

import {connect} from 'react-redux';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import getCompanies from '../../../lib/segments/transportFeatures/getCompanies';
import getThreadUrlForSegment from '../../../lib/segments/getThreadUrlForSegment';

import Icon from '../../Icon/Icon';
import Link from '../../Link';
import SegmentTypeInfo from './SegmentTypeInfo';
import SegmentMainAction from '../SegmentMainAction';
import SegmentTransport from '../../SegmentTransport/SegmentTransport';

import threadKeyset from '../../../i18n/thread';
import segmentKeyset from '../../../i18n/segment';
import typesKeyset from '../../../i18n/transport-types';
import {isCity} from '../../../lib/point/pointType';

const b = B('SegmentFullInfo');

const mapStateToProps = ({
    language,
    tld,
    seoQueryParams,
    user,
    environment,
}) => ({
    language,
    tld,
    seoQueryParams,
    clientId: user.clientId,
    environment,
});

class SegmentFullInfo extends Component {
    getThreadBlock() {
        const {
            segment,
            context,
            seoQueryParams,
            language,
            clientId,
            tld,
            environment: {production},
        } = this.props;

        const {title, thread, number, transport} = segment;
        const {code: transportType} = transport;

        if (!thread) {
            return null;
        }

        const link = getThreadUrlForSegment({
            segment,
            tld,
            language,
            isToCitySearchContext: isCity(context?.to),
            seoQueryParams,
            clientId,
            isProduction: production,
        });

        if (!link) {
            return null;
        }

        return (
            <div className={b('thread')}>
                <Link
                    href={link}
                    title={threadKeyset.get(`title-${transportType}`, {
                        number,
                        title,
                    })}
                >
                    <Icon className={b('threadIcon')} glyph={IconGlyph.route} />

                    {segmentKeyset('route-link', {
                        transportType: typesKeyset.get(
                            `type-${transportType}-genitive`,
                        ),
                    })}
                </Link>
            </div>
        );
    }

    render() {
        const {
            sort,
            segment,
            context,
            currencies,
            onDatePickerOpen,
            tld,
            language,
            isSuburbanSearchResult,
        } = this.props;
        const {
            number,
            company,
            companies,
            transport: {code: transportType},
        } = segment;

        const numberIsDefined = number && number.trim() !== '';
        const title = numberIsDefined
            ? `${number} ${segment.title}`
            : segment.title;

        return (
            <div className={b()}>
                <div className={b('info')}>
                    <div className={b('title')}>{title}</div>

                    <SegmentTransport
                        className={b('company')}
                        features={getCompanies(
                            tld,
                            language,
                            company,
                            companies,
                        )}
                        transportType={transportType}
                    />

                    <SegmentTypeInfo
                        segment={segment}
                        isSuburbanSearchResult={isSuburbanSearchResult}
                    />
                </div>

                {this.getThreadBlock()}

                <div className={b('mainAction')}>
                    <SegmentMainAction
                        sort={sort}
                        segment={segment}
                        context={context}
                        currencies={currencies}
                        onDatePickerOpen={onDatePickerOpen}
                    />
                </div>
            </div>
        );
    }
}

export default connect(mapStateToProps)(SegmentFullInfo);
