import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';
import {connect} from 'react-redux';
import {publish} from 'pubsub-js';

import {SEGMENTS} from '../../../lib/constants/pubSubEvents';

import {TransportType} from '../../../lib/transportType';

import getTariffKeys from '../../../lib/segments/getTariffKeys';
import {getBuyLinkText} from '../../../lib/segments/snippetUtils';

import Button from '../../Button/Button';
import SegmentBuyLink from '../../SegmentBuyLink';

import keyset from '../../../i18n/segment-date-picker';

const b = B('SegmentMainAction');

const mapStateToProps = ({flags, seoQueryParams}) => ({
    flags,
    seoQueryParams,
});

class SegmentMainAction extends PureComponent {
    openPartnerPicker = () => {
        const {segment, sort, flags, seoQueryParams} = this.props;
        const {mainTariffKey} = getTariffKeys(
            segment,
            flags,
            seoQueryParams,
            sort,
        );

        publish(SEGMENTS.SEGMENT_PARTNER_PICKER_CLICK, {
            segment,
            klass: mainTariffKey,
        });
    };

    getSegmentBuyLink() {
        const {segment, sort, flags, seoQueryParams} = this.props;
        const {mainTariffKey} = getTariffKeys(
            segment,
            flags,
            seoQueryParams,
            sort,
        );

        if (!mainTariffKey) {
            return null;
        }

        return (
            <SegmentBuyLink
                className={b()}
                segment={segment}
                tariffClass={mainTariffKey}
                openPartnerPicker={this.openPartnerPicker}
            >
                {getBuyLinkText(segment)}
            </SegmentBuyLink>
        );
    }

    getSegmentDatePicker() {
        const {segment, onDatePickerOpen} = this.props;

        return (
            <Button
                className={b('datePicker')}
                onClick={onDatePickerOpen}
                title={keyset(`button-title-${segment.transport.code}`)}
            >
                {keyset('button-text')}
            </Button>
        );
    }

    render() {
        const {segment} = this.props;
        const {
            runDays,
            hasTrainTariffs,
            transport: {code},
        } = segment;

        if (code === TransportType.suburban && !hasTrainTariffs) {
            return null;
        }

        if (runDays) {
            return this.getSegmentDatePicker();
        }

        return this.getSegmentBuyLink();
    }
}

export default connect(mapStateToProps)(SegmentMainAction);
