import {createContext} from 'react';

import {TransportType} from '../lib/transportType';

export interface ISegmentBuyButtonUtmContext {
    getUtmMedium(
        transportType: TransportType,
        isTransferSegment?: boolean,
        isAllDaysSearch?: boolean,
    ): string | undefined;
}

// Контекст utm medium для кнопок покупки
const SegmentBuyButtonUtmContext = createContext<ISegmentBuyButtonUtmContext>({
    getUtmMedium: () => undefined,
});

export default SegmentBuyButtonUtmContext;
export const SegmentBuyButtonUtmContextProvider =
    SegmentBuyButtonUtmContext.Provider;
