import {createContext} from 'react';

import {TransportType} from '../lib/transportType';

interface ISegmentCompanyLinkUtmContext {
    getUtmMedium(transportType: TransportType): string | undefined;
}

// Контекст utm medium для ссылки на компанию
const SegmentCompanyLinkUtmContext =
    createContext<ISegmentCompanyLinkUtmContext>({
        getUtmMedium: () => undefined,
    });

export default SegmentCompanyLinkUtmContext;
export const SegmentCompanyLinkUtmContextProvider =
    SegmentCompanyLinkUtmContext.Provider;
