import {createContext} from 'react';

import {TransportType} from '../lib/transportType';

interface ISegmentTitleLinkUtmContext {
    getUtmMedium(transportType: TransportType): string | undefined;
}

// Контекст utm medium для ссылки в заголовке сегмента
const SegmentTitleLinkUtmContext = createContext<ISegmentTitleLinkUtmContext>({
    getUtmMedium: () => undefined,
});

export default SegmentTitleLinkUtmContext;
export const SegmentTitleLinkUtmContextProvider =
    SegmentTitleLinkUtmContext.Provider;
