import {useSelector} from 'react-redux';

import applyUtm from '../lib/url/applyUtm';
import {userSelector} from '../selectors/userSelector';
import {seoQueryParamsSelector} from '../selectors/seoQueryParamsSelector';

export function useApplyUtm(url: string, utmMedium?: string): string {
    const seoQueryParams = useSelector(seoQueryParamsSelector);
    const {clientId} = useSelector(userSelector);

    return applyUtm(url, seoQueryParams, clientId, utmMedium);
}
