import i18n from "../_utils/i18n";
import hasKey from "../_utils/hasKey";

export default function (keyset) {
    const keysetObject = function (key, params) {
        return i18n(keyset, key, params);
    };

    keysetObject.hasKey = function (key) {
        return hasKey(keyset, key);
    };

    keysetObject.get = function (key, params) {
        return hasKey(keyset, key) ?
            i18n(keyset, key, params) :
            ""
    };

    return keysetObject;
};
