/**
 * @param {Object} keyset
 * @param {String} key
 * @param {Object} [params]
 * @returns {String}
 */
export default function (keyset, key, params) {
    params = params || {};
    const data = keyset.data;
    const value = data[key];

    if (value === undefined) {
        throw 'i18n error! "' + keyset.name + '" keysetRU does not contain "' + key + '" key.';
    }

    if (typeof value === 'function') {
        return value(params);
    }

    return value;
};
