import { isValidElement } from 'react';

export default function insertMarkupIntoKey(keysetFunction, key, params) {
    const SEPARATOR = '%%';
    const MARKER = '__';

    const placeholderParams = Object.keys(params).reduce((result, paramName) => {
        if (isValidElement(params[paramName])) {
            result[paramName] = `${SEPARATOR}${MARKER}${paramName}${SEPARATOR}`;
        } else {
            result[paramName] = params[paramName];
        }
        return result;
    }, {});

    const resultWithPlaceholders = keysetFunction(key, placeholderParams);
    const splittedResult = resultWithPlaceholders.split(SEPARATOR);

    return splittedResult
        .filter((part) => part !== '')
        .map((part) => {
            if (part.startsWith(MARKER)) {
                const paramName = part.substr(MARKER.length);

                return params[paramName];
            }

            return part;
        });
}
