import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "meta-search-v2",
    data: {
        "default-description": "Расписание движения самолётов, поездов, электричек и автобусов. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.",
        "description": "Расписание движения самолётов, поездов, электричек и автобусов. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.",
        "description-transport-all": function(params){return "Расписание транспорта "+params.from+" — "+params.to+": "+params.transportTypes+". Цена билета, купить билет онлайн.";},
        "description-transport-bus": function(params){return "Расписание автобусов "+params.from+" — "+params.to+", цена билетов, купить билет онлайн. График движения автобусов, маршрут следования со всеми остановками, автовокзалы отправления и прибытия.";},
        "description-transport-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from+" – "+params.to+" на сегодня, завтра, на все дни с изменениями.";},
        "description-transport-lastochka-price": function(params){return "Расписание электричек «Ласточка» "+params.from+" – "+params.to+" на сегодня, завтра, на все дни с изменениями. Цена билетов от "+params.price+".";},
        "description-transport-plane": function(params){return "Расписание самолетов "+params.from+" — "+params.to+", цена авиабилетов, купить билет онлайн.";},
        "description-transport-suburban": function(params){return "Расписание электричек "+params.from+" — "+params.to+" на сегодня, завтра, все дни с изменениями.";},
        "description-transport-suburban-price": function(params){return "Расписание электричек "+params.from+" — "+params.to+" на сегодня, завтра, все дни с изменениями. Цена билетов от "+params.price+".";},
        "description-transport-train": function(params){return "Расписание поездов "+params.from+" — "+params.to+" со всеми изменениями. Стоимость билетов, покупка жд билетов онлайн.";},
        "description-transport-train-price": function(params){return "Расписание поездов "+params.from+" — "+params.to+" со всеми изменениями. Стоимость билетов, покупка жд билетов онлайн. Цена билетов от "+params.price+".";},
        "description-transport-water": function(params){return "Расписание теплоходов "+params.from+" — "+params.to+".";},
        "og:default-description": "Расписание движения самолётов, поездов, электричек и автобусов.",
        "og:description": "Расписание движения самолётов, поездов, электричек и автобусов."
    }
});
