import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "meta-search-v2",
    data: {
        "default-description": "Розклад руху літаків, потягів, електричок і автобусів. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.",
        "description": "Розклад руху літаків, потягів, електричок і автобусів. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.",
        "description-transport-all": function(params){return "Розклад транспорту "+params.from+" – "+params.to+": "+params.transportTypes+". Ціна квитка, придбати квиток онлайн.";},
        "description-transport-bus": function(params){return "Розклад автобусів "+params.from+" – "+params.to+", ціна квитків, придбати квиток онлайн. Графік руху автобусів, маршрут слідування з усіма зупинками, автовокзали відправлення та прибуття.";},
        "description-transport-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from+" – "+params.to+" на сегодня, завтра, на все дни с изменениями.";},
        "description-transport-lastochka-price": function(params){return "Расписание электричек «Ласточка» "+params.from+" – "+params.to+" на сегодня, завтра, на все дни с изменениями. Цена билетов от "+params.price+".";},
        "description-transport-plane": function(params){return "Розклад літаків "+params.from+" – "+params.to+", ціна авіаквитків, придбати квиток онлайн.";},
        "description-transport-suburban": function(params){return "Розклад електричок "+params.from+" – "+params.to+" на сьогодні, завтра, усі дні зі змінами.";},
        "description-transport-suburban-price": function(params){return "Розклад електричок "+params.from+" – "+params.to+" на сьогодні, завтра, усі дні зі змінами. Ціна квитків від "+params.price+".";},
        "description-transport-train": function(params){return "Розклад потягів "+params.from+" – "+params.to+" з усіма змінами. Вартість квитків, придбання залізничних квитків онлайн.";},
        "description-transport-train-price": function(params){return "Розклад потягів "+params.from+" – "+params.to+" з усіма змінами. Вартість квитків, придбання залізничних квитків онлайн. Ціна квитків від "+params.price+".";},
        "description-transport-water": function(params){return "Розклад теплоходів "+params.from+" – "+params.to+".";},
        "og:default-description": "Розклад руху літаків, потягів, електричок і автобусів.",
        "og:description": "Розклад руху літаків, потягів, електричок і автобусів."
    }
});
