import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "meta-search",
    data: {
        "default-description": "Расписание движения самолётов, поездов, электричек и автобусов. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.",
        "description": "Расписание движения самолётов, поездов, электричек и автобусов. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.",
        "description-transport-all": function(params){return params.from+" — "+params.to+": актуальное расписание "+params.transport+" на "+params.year+" год. Цены на билеты. Покупка билетов "+params.from+" — "+params.to+" онлайн. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.";},
        "description-transport-bus": function(params){return params.from+" — "+params.to+": расписание автобусов на "+params.year+" год. Цены на билеты. Покупка билетов на автобус "+params.from+" — "+params.to+" онлайн. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.";},
        "description-transport-plane": function(params){return params.from+" — "+params.to+": расписание самолётов на "+params.year+" год. Цены на авиабилеты. Покупка билетов на самолёт "+params.from+" — "+params.to+" онлайн. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.";},
        "description-transport-suburban": function(params){return params.from+" — "+params.to+": расписание электричек на "+params.year+" год. Расписание на сегодня, завтра с учётом изменений. Стоимость билетов, тарифы. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.";},
        "description-transport-train": function(params){return params.from+" — "+params.to+": актуальное расписание поездов на "+params.year+" год. Цены на ж/д билеты. Покупка билетов на поезд "+params.from+" — "+params.to+" онлайн. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.";},
        "description-transport-water": function(params){return params.from+" — "+params.to+": расписание теплоходов на "+params.year+" год. Цены на билеты. На сервисе Яндекс Расписания можно построить маршруты на самолётах, поездах, электричках и автобусах; посмотреть расписания и табло вокзалов и аэропортов по России и в странах СНГ, а также купить билет на самолёт, поезд или автобус.";},
        "og:default-description": "Расписание движения самолётов, поездов, электричек и автобусов.",
        "og:description": "Расписание движения самолётов, поездов, электричек и автобусов."
    }
});
