import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "meta-search",
    data: {
        "default-description": "Розклад руху літаків, потягів, електричок і автобусів. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.",
        "description": "Розклад руху літаків, потягів, електричок і автобусів. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.",
        "description-transport-all": function(params){return params.from+" – "+params.to+": актуальний розклад "+params.transport+" на "+params.year+" рік. Ціни на квитки. Придбання квитків "+params.from+" – "+params.to+" онлайн. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.";},
        "description-transport-bus": function(params){return params.from+" – "+params.to+": розклад автобусів на "+params.year+" рік. Ціни на квитки. Придбання квитків на автобус "+params.from+" – "+params.to+" онлайн. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.";},
        "description-transport-plane": function(params){return params.from+" – "+params.to+": розклад літаків на "+params.year+" рік. Ціни на авіаквитки. Придбання квитків на літак "+params.from+" – "+params.to+" онлайн. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.";},
        "description-transport-suburban": function(params){return params.from+" – "+params.to+": розклад електричок на "+params.year+" рік. Розклад на сьогодні, завтра з урахуванням змін. Вартість квитків, тарифи. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.";},
        "description-transport-train": function(params){return params.from+" – "+params.to+": актуальний розклад потягів на "+params.year+" рік. Ціни на залізничні квитки. Придбання квитків на потяг "+params.from+" – "+params.to+" онлайн. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.";},
        "description-transport-water": function(params){return params.from+" – "+params.to+": розклад теплоходів на "+params.year+" рік. Ціни на квитки. За допомогою сервісу Яндекс.Розклади можна побудувати маршрути для подорожей літаками, потягами, електричками й автобусами; переглянути розклади й табло вокзалів та аеропортів у Росії та країнах СНД, а також придбати квиток на літак, потяг або автобус.";},
        "og:default-description": "Розклад руху літаків, поїздів, електричок і автобусів.",
        "og:description": "Розклад руху літаків, поїздів, електричок і автобусів."
    }
});
