import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "meta-station",
    data: {
        "default-description-train": function(params){return "Онлайн-табло по "+params.titleDative+" на сегодня, завтра, все дни с изменениями. На сервисе Яндекс Расписания можно посмотреть маршруты электричек и поездов дальнего следования со всеми остановками и узнать стоимость билетов.";},
        "default-title-train": function(params){return "Расписание по "+params.titleDative+". График "+params.year+" г, с учетом оперативных изменений";},
        "description-bus": function(params){return params.title+": расписание автобусов на сегодня, завтра, на все дни. Справочная информация об автовокзале: адрес, телефон.";},
        "description-suburban": function(params){return "Расписание электричек по "+params.title+" на сегодня, завтра, все дни с изменениями. На сервисе Яндекс Расписания можно посмотреть маршруты пригородных поездов со всеми остановками и узнать стоимость билетов на электропоезда.";},
        "description-tablo": function(params){return "Онлайн табло по "+params.titleDative+": расписание поездов дальнего следования и электричек на "+params.year+" год с учетом оперативных изменений. Телефон справочной, адрес ЖД вокзала и стоимость билетов на сервисе Яндекс Расписания.";},
        "description-tablo-popular": function(params){return "Онлайн табло "+params.title+": расписание поездов дальнего следования и электричек на "+params.year+" год с учетом оперативных изменений. Телефон справочной, адрес ЖД вокзала и стоимость билетов на сервисе Яндекс Расписания.";},
        "description-train": function(params){return "Онлайн табло по "+params.titleDative+": расписание поездов дальнего следования на "+params.year+" год с учетом оперативных изменений. Телефон справочной, адрес ЖД вокзала и стоимость билетов на сервисе Яндекс Расписания.";},
        "description-train-popular": function(params){return "Онлайн табло "+params.title+": расписание поездов дальнего следования на "+params.year+" год с учетом оперативных изменений. Телефон справочной, адрес ЖД вокзала и стоимость билетов на сервисе Яндекс Расписания.";},
        "description-water": function(params){return params.title+": расписание водного транспорта в реальном времени. На сервисе Яндекс Расписания можно узнать расписание и режим работы речных и морских вокзалов, паромных переправ, причалов и пристаней.";},
        "title-bus": function(params){return "Расписание автобусов "+params.title+" на "+params.year+" год со всеми изменениями — Яндекс Расписания";},
        "title-suburban": function(params){return "Расписание электричек "+params.titleGenitive+". График "+params.year+" г, с учетом оперативных изменений";},
        "title-suburban-popular": function(params){return "Расписание электричек "+params.titleGenitive+" ("+params.cityTitle+"). График "+params.year+" г, с учетом оперативных изменений";},
        "title-tablo-arrival": function(params){return params.title+": расписание поездов и электричек на "+params.year+" год. Прибытие";},
        "title-tablo-arrival-popular": function(params){return params.title+" ("+params.cityTitle+"): расписание поездов и электричек на "+params.year+" год. Прибытие";},
        "title-tablo-departure": function(params){return params.title+": расписание поездов и электричек на "+params.year+" год. Отправление";},
        "title-tablo-departure-popular": function(params){return params.title+" ("+params.cityTitle+"): расписание поездов и электричек на "+params.year+" год. Отправление";},
        "title-train-arrival": function(params){return params.title+": расписание поездов на "+params.year+" год. Прибытие";},
        "title-train-arrival-popular": function(params){return params.title+" ("+params.cityTitle+"): расписание поездов на "+params.year+" год. Прибытие";},
        "title-train-departure": function(params){return params.title+": расписание поездов на "+params.year+" год. Отправление";},
        "title-train-departure-popular": function(params){return params.title+" ("+params.cityTitle+"): расписание поездов на "+params.year+" год. Отправление";},
        "title-water": function(params){return params.title+": расписание на "+params.year+" год — Яндекс Расписания";}
    }
});
