import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "page",
    data: {
        "description": "Расписание движения самолётов, поездов, электричек и автобусов. На сервисе Яндекс Расписания можно строить маршруты по всему миру — на самолётах, поездах, электричках, автобусах и другом транспорте. А также изучать табло вокзалов и аэропортов. Сервис работает в России и странах СНГ, а также помогает выбрать и купить билет на самолёт, поезд или автобус онлайн.",
        "description-home": "Актуальное расписание электричек, автобусов, поездов, самолётов, теплоходов и паромов; онлайн табло вокзалов и аэропортов. Сервис Яндекс Расписания поможет построить маршрут по всему миру, а также выбрать и купить билет онлайн на самолёт, поезд или автобус.",
        "description-with-stations": function(params){return "Актуальное расписание "+params.types+"; онлайн табло "+params.stations+" "+params.titleGenitive+". Сервис Яндекс Расписания поможет построить маршрут по всему миру, а также выбрать и купить билет онлайн на самолёт, поезд или автобус.";},
        "description-without-stations": function(params){return "Актуальное расписание "+params.types+" "+params.titleGenitive+". Сервис Яндекс Расписания поможет построить маршрут по всему миру, а также выбрать и купить билет онлайн на самолёт, поезд или автобус.";},
        "og:description": "Расписание движения самолётов, поездов, электричек и автобусов",
        "stations-plane": "аэропортов",
        "stations-train": "вокзалов",
        "stations-train-plane": "вокзалов и аэропортов",
        "title": "Яндекс Расписания",
        "title-city": function(params){return params.city+". Расписание транспорта";},
        "title-city-genitive": function(params){return "Расписание транспорта "+params.titleGenitive+" – Яндекс Расписания";},
        "title-city-types": function(params){return params.city+". Расписание "+params.types;},
        "title-index": "Расписание электричек, поездов, автобусов и самолётов — Яндекс Расписания",
        "title-index-types": function(params){return "Расписание "+params.types;}
    }
});
