import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "page",
    data: {
        "description": "Розклад руху літаків, потягів, електричок і автобусів. За допомогою сервісу Яндекс.Розклади можна будувати маршрути по всьому світу – літаками, потягами, електричками, автобусами й іншим транспортом. А також переглядати табло вокзалів і аеропортів. Сервіс працює в Росії та країнах СНД, а також допомагає вибрати та придбати квиток на літак, потяг або автобус онлайн.",
        "description-home": "Актуальний розклад електричок, автобусів, потягів, літаків, теплоходів і поромів; онлайн-табло вокзалів і аеропортів. Сервіс Яндекс.Розклади допоможе побудувати маршрут по всьому світу, а також вибрати та придбати квиток онлайн на літак, потяг або автобус.",
        "description-with-stations": function(params){return "Актуальний розклад "+params.types+"; онлайн-табло "+params.stations+" "+params.titleGenitive+". Сервіс Яндекс.Розклади допоможе побудувати маршрут по всьому світу, а також вибрати та придбати квиток онлайн на літак, потяг або автобус.";},
        "description-without-stations": function(params){return "Актуальний розклад "+params.types+" "+params.titleGenitive+". Сервіс Яндекс.Розклади допоможе побудувати маршрут по всьому світу, а також вибрати та придбати квиток онлайн на літак, потяг або автобус.";},
        "og:description": "Розклад руху літаків, поїздів, електричок і автобусів",
        "stations-plane": "аеропортів",
        "stations-train": "вокзалів",
        "stations-train-plane": "вокзалів і аеропортів",
        "title": "Яндекс.Розклади",
        "title-city": function(params){return params.city+". Розклад транспорту";},
        "title-city-genitive": function(params){return "Розклад транспорту "+params.titleGenitive+" – Яндекс.Розклади";},
        "title-city-types": function(params){return params.city+". Розклад "+params.types;},
        "title-index": "Розклад електричок, потягів, автобусів і літаків – Яндекс.Розклади",
        "title-index-types": function(params){return "Розклад "+params.types;}
    }
});
