import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "search-description-v2",
    data: {
        "class-business": "бизнес-класса",
        "class-common": "в общий вагон",
        "class-compartment": "в купе",
        "class-economy": "эконом-класса",
        "class-platzkarte": "в плацкартный вагон",
        "class-sitting": "в сидячий вагон",
        "class-suburban": "по полному тарифу",
        "class-suite": "в СВ",
        "element-from-value": function(params){return params.title+" от "+params.value;},
        "text-all": function(params){return "Расписание транспорта "+params.from.title+" — "+params.to.title+": "+params.transportTypes+". Время в пути: "+params.typesWithDuration+". Купить билет онлайн.";},
        "text-all-price": function(params){return "Расписание транспорта "+params.from.title+" — "+params.to.title+": "+params.transportTypes+". Цена билета "+params.typesWithPrices+". Время в пути: "+params.typesWithDuration+". Купить билет онлайн.";},
        "text-bus": function(params){return "Расписание автобусов "+params.from.title+" — "+params.to.title+", цена билетов, покупка билетов онлайн. График движения автобусов, маршрут следования со всеми остановками, автовокзалы отправления и прибытия. Время в пути от "+params.duration+". Информация об автобусных маршрутах разных транспортных компаний, от различных автовокзалов.";},
        "text-bus-price": function(params){return "Расписание автобусов "+params.from.title+" — "+params.to.title+", цена билетов, покупка билетов онлайн. График движения автобусов, маршрут следования со всеми остановками, автовокзалы отправления и прибытия. Стоимость билета от "+params.price+". Время в пути от "+params.duration+". Информация об автобусных маршрутах разных транспортных компаний, от различных автовокзалов.";},
        "text-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая «Ласточка» "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Яндекс Расписания показывают график движения «Ласточек» с учётом отмен и других изменений.";},
        "text-lastochka-price": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая «Ласточка» "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Цена билета по полному тарифу — от "+params.price+". Яндекс Расписания показывают график движения «Ласточек» с учётом отмен и других изменений.";},
        "text-plane": function(params){return "Минимальное время в пути по маршруту "+params.from.title+" — "+params.to.title+" составляет "+params.duration+". Сервисы Яндекса показывают график вылетов и прилётов с учётом задержек, отмен и других изменений, собирают данные о ценах на авиабилеты от многих продавцов, помогают купить авиабилеты дёшево.";},
        "text-plane-price": function(params){return "Минимальное время в пути по маршруту "+params.from.title+" — "+params.to.title+" составляет "+params.duration+". Цены билетов начинаются от "+params.price+". Сервисы Яндекса показывают график вылетов и прилётов с учётом задержек, отмен и других изменений, собирают данные о ценах на авиабилеты от многих продавцов, помогают купить авиабилеты дёшево.";},
        "text-suburban": function(params){return "Расписание электричек "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая электричка "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Яндекс Расписания показывают график движения электричек с учётом отмен и других изменений.";},
        "text-suburban-lastochki": function(params){return "Расписание электричек и «Ласточек» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая электричка "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Яндекс Расписания показывают график движения электричек с учётом отмен и других изменений.";},
        "text-suburban-price": function(params){return "Расписание электричек "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая электричка "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Цена билета по полному тарифу — от "+params.price+". Яндекс Расписания показывают график движения электричек с учётом отмен и других изменений.";},
        "text-suburban-price-lastochki": function(params){return "Расписание электричек и «Ласточек» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая электричка "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Цена билета по полному тарифу — от "+params.price+". Яндекс Расписания показывают график движения электричек с учётом отмен и других изменений.";},
        "text-train": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-train-price": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Цена билета "+params.trainClassesWithPrices+". Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-train-price-subtypes": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Билеты на "+plural({"count":params.subtypesCount,"one":"поезд","some":"поезда","many":"поезда"})+" "+params.subtypesWithPrices+". Цена билета "+params.trainClassesWithPrices+". Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-water": function(params){return "Самый быстрый теплоход проходит маршрут "+params.from.title+" — "+params.to.title+" за "+params.duration+". На Яндекс Расписаниях можно найти график движения судов и расписание по пристаням.";},
        "text-water-price": function(params){return "Самый быстрый теплоход проходит маршрут "+params.from.title+" — "+params.to.title+" за "+params.duration+". Цена билета составляет от "+params.price+". На Яндекс Расписаниях можно найти график движения судов и расписание по пристаням.";},
        "title-all": function(params){return "Расписание транспорта "+params.from.title+" — "+params.to.title+": "+params.transportTypes;},
        "title-bus": function(params){return "Расписание автобусов "+params.from.title+" — "+params.to.title+", цена билетов, купить билет онлайн";},
        "title-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" – "+params.to.title+" с изменениями, цена билетов";},
        "title-plane": function(params){return "Расписание самолетов "+params.from.title+" — "+params.to.title+", цена билетов, купить билет онлайн";},
        "title-suburban": function(params){return "Расписание электричек "+params.from.title+" — "+params.to.title+" с изменениями, цена билетов";},
        "title-train": function(params){return "Поезда "+params.from.title+" — "+params.to.title+": расписание, цены и ж/д билеты";},
        "title-water": function(params){return "Расписание теплоходов "+params.from.title+" — "+params.to.title;},
        "type-bus": "на автобус",
        "type-plane": "на самолет",
        "type-suburban": "на электричку",
        "type-train": "на поезд",
        "type-water": "на пароход"
    }
});
