import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "search-description-v2",
    data: {
        "class-business": "бизнес-санат",
        "class-common": "жалпы вагонға",
        "class-compartment": "купеде",
        "class-economy": "эконом-санат",
        "class-platzkarte": "в плацкартный вагон",
        "class-sitting": "отырып баратын вагонға",
        "class-suburban": "толық тариф бойынша",
        "class-suite": "ЖВ-да",
        "element-from-value": function(params){return params.title+" бастап "+params.value;},
        "text-all": function(params){return "Көлік кестесі "+params.from.title+" — "+params.to.title+": "+params.transportTypes+". Жолдағы уақыт: "+params.typesWithDuration+". Билетті онлайн түрде сатып алу.";},
        "text-all-price": function(params){return "Көлік кестесі "+params.from.title+" — "+params.to.title+": "+params.transportTypes+". Билет бағасы "+params.typesWithPrices+". Жолдағы уақыт: "+params.typesWithDuration+". Билетті онлайн түрде сатып алу.";},
        "text-bus": function(params){return params.from.title+" — "+params.to.title+" автобустар кестесі, билеттер бағасы, билеттерді онлайн сатып алу. Автобустардың қозғалыс кестесі, барлық аялдамалары көрсетілген жүру бағдары, келу және жөнелту вокзалдары. Жолдағы уақыт "+params.duration+" басталады. Әр түрлі көліктік компаниялардан, әр түрлі вокзалдардан алынатын автобус бағдарлары туралы ақпарат.";},
        "text-bus-price": function(params){return params.from.title+" — "+params.to.title+" автобустар кестесі, билеттер бағасы, билеттерді онлайн сатып алу. Автобустардың қозғалыс кестесі, барлық аялдамалары көрсетілген жүру бағдары, келу және жөнелту вокзалдары. Билеттердің құны "+params.price+" басталады. Жолдағы уақыт "+params.duration+" басталады. Әртүрлі көліктік компаниялардан, әр түрлі вокзалдардан алынатын автобус бағдарлары туралы ақпарат.";},
        "text-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая «Ласточка» "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Яндекс Расписания показывают график движения «Ласточек» с учётом отмен и других изменений.";},
        "text-lastochka-price": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая «Ласточка» "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Цена билета по полному тарифу — от "+params.price+". Яндекс Расписания показывают график движения «Ласточек» с учётом отмен и других изменений.";},
        "text-plane": function(params){return params.from.title+" — "+params.to.title+" бағдары бойынша ең аз уақыт "+params.duration+" құрайды. Яндекс сервистері кідірістер, тоқтатулар мен басқа да өзгертулерді ескере отырып ұшу және ұшып келу кестелерін көрсетеді, әуе билеттеріне көптеген сатушылардан бағалар туралы мәліметтерді жинақтайды, әуе билеттерін арзан сатып алуға көмектеседі.";},
        "text-plane-price": function(params){return params.from.title+" — "+params.to.title+" бағдары бойынша ең аз уақыт "+params.duration+" құрайды. Билеттердің бағасы "+params.price+" басталады. Яндекс сервистері кідірістер, тоқтатулар мен басқа да өзгертулерді ескере отырып ұшу және ұшып келу кестелерін көрсетеді, әуе билеттеріне көптеген сатушылардан бағалар туралы мәліметтерді жинақтайды, әуе билеттерін арзан сатып алуға көмектеседі.";},
        "text-suburban": function(params){return params.from.title+" — "+params.to.title+" электричкаларының бүгін, ертең, барлық күндерге өзгертулер мен тоқтаулары ескерілген кестесі. "+params.from.title+" — "+params.to.title+" арасындағы ең жылдам электричка "+params.duration+" ішінде жетеді. Яндекс.Кестелер тоқтатулар мен басқа да өзгерістерді ескере отырып, электричкалардың қозғалыс кестесін көрсетеді.";},
        "text-suburban-lastochki": function(params){return params.from.title+" — "+params.to.title+" электричкалар мен «Ласточкалардың» бүгін, ертең, барлық күндерге өзгертулер мен тоқтаулары ескерілген кестесі. "+params.from.title+" — "+params.to.title+" арасындағы ең жылдам электричка "+params.duration+" ішінде жетеді. Яндекс.Кестелер тоқтатулар мен басқа да өзгерістерді ескере отырып, электричкалардың қозғалыс кестесін көрсетеді.";},
        "text-suburban-price": function(params){return params.from.title+" — "+params.to.title+" электричкаларының бүгін, ертең, барлық күндерге өзгертулер мен тоқтаулары ескерілген кестесі. "+params.from.title+" — "+params.to.title+" арасындағы ең жылдам электричка "+params.duration+" ішінде жетеді. Толық тариф бойынша билеттің бағасы "+params.price+" басталады. Яндекс.Кестелер тоқтатулар мен басқа да өзгерістерді ескере отырып, электричкалардың қозғалыс кестесін көрсетеді.";},
        "text-suburban-price-lastochki": function(params){return "Электричкалар мен «Ласточкалардың» "+params.from.title+" — "+params.to.title+" бүгінге, ертеңге, барлық күндерге өзгертулер мен тоқтаулары ескерілген кестесі. "+params.from.title+" — "+params.to.title+" арасындағы ең жылдам электричка "+params.duration+" ішінде жетеді. Толық тариф бойынша билеттің бағасы "+params.price+" басталады. Яндекс.Кестелер тоқтатулар мен басқа да өзгерістерді ескере отырып, электричкалардың қозғалыс кестесін көрсетеді.";},
        "text-train": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-train-price": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Цена билета "+params.trainClassesWithPrices+". Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-train-price-subtypes": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Билеты на "+plural({"count":params.subtypesCount,"one":"поезд","some":"поезда","many":"поезда"})+" "+params.subtypesWithPrices+". Цена билета "+params.trainClassesWithPrices+". Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-water": function(params){return "Ең жылдам теплоход "+params.from.title+" — "+params.to.title+" бағдарын "+params.duration+" ішінде өтеді. Яндекс.Кестелерде кемелердің қозғалыс кестесін және айлақтар бойынша кестені табуға болады.";},
        "text-water-price": function(params){return "Ең жылдам теплоход "+params.from.title+" — "+params.to.title+" бағдарын "+params.duration+" ішінде өтеді. Билеттің құны "+params.price+" басталады. Яндекс.Кестелерде кемелердің қозғалыс кестесін және айлақтар бойынша кестені табуға болады.";},
        "title-all": function(params){return params.from.title+" — "+params.to.title+" арасындағы көлік кестесі: "+params.transportTypes;},
        "title-bus": function(params){return params.from.title+"— "+params.to.title+" автобустары кестесі, билеттер бағасы, билетті онлайн сатып алу";},
        "title-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" – "+params.to.title+" с изменениями, цена билетов";},
        "title-plane": function(params){return params.from.title+"— "+params.to.title+" ұшақтары кестесі, билеттер бағасы, билетті онлайн сатып алу";},
        "title-suburban": function(params){return params.from.title+"— "+params.to.title+" электричкаларының өзгертулермен берілген кестесі, билеттер бағасы";},
        "title-train": function(params){return "Поезда "+params.from.title+" — "+params.to.title+": расписание, цены и ж/д билеты";},
        "title-water": function(params){return "Теплоходтар кестесі: "+params.from.title+" — "+params.to.title;},
        "type-bus": "автобусқа",
        "type-plane": "ұшаққа",
        "type-suburban": "электричкаға",
        "type-train": "пойызға",
        "type-water": "пароходқа"
    }
});
