import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "search-description-v2",
    data: {
        "class-business": "бізнес-класу",
        "class-common": "у загальний вагон",
        "class-compartment": "у купе",
        "class-economy": "економ-класу",
        "class-platzkarte": "в плацкартный вагон",
        "class-sitting": "у сидячий вагон",
        "class-suburban": "за повним тарифом",
        "class-suite": "у СВ",
        "element-from-value": function(params){return params.title+" від "+params.value;},
        "text-all": function(params){return "Розклад транспорту "+params.from.title+" – "+params.to.title+": "+params.transportTypes+". Час у дорозі: "+params.typesWithDuration+". Придбати квиток онлайн.";},
        "text-all-price": function(params){return "Розклад транспорту "+params.from.title+" – "+params.to.title+": "+params.transportTypes+". Ціна квитка "+params.typesWithPrices+". Час у дорозі: "+params.typesWithDuration+". Придбати квиток онлайн.";},
        "text-bus": function(params){return "Розклад автобусів "+params.from.title+" – "+params.to.title+", ціна квитків, придбання квитків онлайн. Графік руху автобусів, маршрут слідування з усіма зупинками, автовокзали відправлення та прибуття. Час у дорозі від "+params.duration+". Інформація про автобусні маршрути різних транспортних компаній, від різних автовокзалів.";},
        "text-bus-price": function(params){return "Розклад автобусів "+params.from.title+" – "+params.to.title+", ціна квитків, придбання квитків онлайн. Графік руху автобусів, маршрут слідування з усіма зупинками, автовокзали відправлення та прибуття. Вартість квитка від "+params.price+". Час у дорозі від "+params.duration+". Інформація про автобусні маршрути різних транспортних компаній, від різних автовокзалів.";},
        "text-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая «Ласточка» "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Яндекс Расписания показывают график движения «Ласточек» с учётом отмен и других изменений.";},
        "text-lastochka-price": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая «Ласточка» "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Цена билета по полному тарифу — от "+params.price+". Яндекс Расписания показывают график движения «Ласточек» с учётом отмен и других изменений.";},
        "text-plane": function(params){return "Мінімальний час у дорозі за маршрутом "+params.from.title+" – "+params.to.title+" становить "+params.duration+". Сервіси Яндекса відображають графік вильотів і прильотів з урахуванням затримок, скасувань та інших змін, збирають дані щодо цін на авіаквитки від багатьох продавців, допомагають дешево придбати авіаквитки.";},
        "text-plane-price": function(params){return "Мінімальний час у дорозі за маршрутом "+params.from.title+" – "+params.to.title+" становить "+params.duration+". Ціни на квитки починаються від "+params.price+". Сервіси Яндекса відображають графік вильотів і прильотів з урахуванням затримок, скасувань та інших змін, збирають дані щодо цін на авіаквитки від багатьох продавців, допомагають дешево придбати авіаквитки.";},
        "text-suburban": function(params){return "Розклад електричок "+params.from.title+" – "+params.to.title+" на сьогодні, завтра, усі дні зі змінами та скасуваннями. Найшвидша електричка "+params.from.title+" – "+params.to.title+" доїжджає за "+params.duration+". Яндекс.Розклади відображають графік руху електричок з урахуванням скасувань та інших змін.";},
        "text-suburban-lastochki": function(params){return "Розклад електричок і «Ластівок» "+params.from.title+" – "+params.to.title+" на сьогодні, завтра, усі дні зі змінами та скасуваннями. Найшвидша електричка "+params.from.title+" – "+params.to.title+" доїжджає за "+params.duration+". Яндекс.Розклади відображають графік руху електричок з урахуванням скасувань та інших змін.";},
        "text-suburban-price": function(params){return "Розклад електричок "+params.from.title+" – "+params.to.title+" на сьогодні, завтра, усі дні зі змінами та скасуваннями. Найшвидша електричка "+params.from.title+" — "+params.to.title+" доїжджає за "+params.duration+". Ціна квитка за повним тарифом – від "+params.price+". Яндекс.Розклади відображають графік руху електричок з урахуванням скасувань та інших змін.";},
        "text-suburban-price-lastochki": function(params){return "Розклад електричок і «Ластівок» "+params.from.title+" – "+params.to.title+" на сьогодні, завтра, усі дні зі змінами та скасуваннями. Найшвидша електричка "+params.from.title+" – "+params.to.title+" доїжджає за "+params.duration+". Ціна квитка за повним тарифом – від "+params.price+". Яндекс.Розклади відображають графік руху електричок з урахуванням скасувань та інших змін.";},
        "text-train": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-train-price": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Цена билета "+params.trainClassesWithPrices+". Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-train-price-subtypes": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Билеты на "+plural({"count":params.subtypesCount,"one":"поезд","some":"поезда","many":"поезда"})+" "+params.subtypesWithPrices+". Цена билета "+params.trainClassesWithPrices+". Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-water": function(params){return "Найшвидший теплохід долає маршрут "+params.from.title+" – "+params.to.title+" за "+params.duration+". На Яндекс.Розкладах можна знайти графік руху суден і розклад за пристанями.";},
        "text-water-price": function(params){return "Найшвидший теплохід долає маршрут "+params.from.title+" – "+params.to.title+" за "+params.duration+". Ціна квитка складає від "+params.price+". На Яндекс.Розкладах можна знайти графік руху суден і розклад за пристанями.";},
        "title-all": function(params){return "Розклад транспорту "+params.from.title+" – "+params.to.title+": "+params.transportTypes;},
        "title-bus": function(params){return "Розклад автобусів "+params.from.title+" – "+params.to.title+", ціна квитків, придбати квиток онлайн";},
        "title-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" – "+params.to.title+" с изменениями, цена билетов";},
        "title-plane": function(params){return "Розклад літаків "+params.from.title+" – "+params.to.title+", ціна квитків, придбати квиток онлайн";},
        "title-suburban": function(params){return "Розклад електричок "+params.from.title+" – "+params.to.title+" зі змінами, ціна квитків";},
        "title-train": function(params){return "Поезда "+params.from.title+" — "+params.to.title+": расписание, цены и ж/д билеты";},
        "title-water": function(params){return "Розклад теплоходів "+params.from.title+" – "+params.to.title;},
        "type-bus": "на автобус",
        "type-plane": "на літак",
        "type-suburban": "на електричку",
        "type-train": "на потяг",
        "type-water": "на пароплав"
    }
});
