import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "search-description-v2",
    data: {
        "class-business": "biznes-klass",
        "class-common": "umumiy vagon",
        "class-compartment": "kupeda",
        "class-economy": "ekonom-klass",
        "class-platzkarte": "в плацкартный вагон",
        "class-sitting": "oʻrindiqli vagon",
        "class-suburban": "butun tarif boʻyicha",
        "class-suite": "SVʼda",
        "element-from-value": function(params){return params.title+" quyidagidan: "+params.value;},
        "text-all": function(params){return params.from.title+" – "+params.to.title+" transport jadvali: "+params.transportTypes+". Safar vaqti: "+params.typesWithDuration+". Chiptani onlayn xarid qilish.";},
        "text-all-price": function(params){return params.from.title+" – "+params.to.title+" transport jadvali: "+params.transportTypes+". Chipta narxi: "+params.typesWithPrices+". Safar vaqti: "+params.typesWithDuration+". Chiptani onlayn xarid qilish.";},
        "text-bus": function(params){return params.from.title+" – "+params.to.title+" avtobuslari jadvali, chipta narxlari, chiptalarni onlayn xarid qilish. Avtobuslarning harakatlanish jadvali, safar marshruti barcha toʻxtash joylari bilan, ketish va kelish avtovokzallari. Safar vaqti "+params.duration+" dan boshlab. Har xil avtovokzallardan turli transport kompaniyalarining avtobus marshrutlari haqida axborot.";},
        "text-bus-price": function(params){return params.from.title+" – "+params.to.title+" avtobuslari jadvali, chipta narxlari, chiptalarni onlayn xarid qilish. Avtobuslarning harakatlanish jadvali, safar marshruti barcha bekatlar bilan, ketish va kelish avtovokzallari. Chipta narxi "+params.price+" dan boshlab. Safar davomiyligi "+params.duration+" dan boshlab. Har xil avtovokzallardan turli transport kompaniyalarining avtobus marshrutlari haqida axborot.";},
        "text-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая «Ласточка» "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Яндекс Расписания показывают график движения «Ласточек» с учётом отмен и других изменений.";},
        "text-lastochka-price": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" — "+params.to.title+" на сегодня, завтра, все дни с изменениями и отменами. Самая быстрая «Ласточка» "+params.from.title+" — "+params.to.title+" доезжает за "+params.duration+". Цена билета по полному тарифу — от "+params.price+". Яндекс Расписания показывают график движения «Ласточек» с учётом отмен и других изменений.";},
        "text-plane": function(params){return params.from.title+" – "+params.to.title+" marshrutida eng qisqa safar vaqti "+params.duration+". Yandex xizmatlari reyslarga doir kechikishlar, bekor qilinishlar va boshqa oʻzgarishlarni hisobga olgan holda parvozlar va qoʻnishlar jadvalini koʻrsatadi hamda koʻplab sotuvchilardan aviachiptalar narxiga oid axborotlarni toʻplab, aviachiptalarni arzon  narxlarda xarid qilishga yordam beradi.";},
        "text-plane-price": function(params){return params.from.title+" – "+params.to.title+" marshrutida eng qisqa safar vaqti "+params.duration+". Chipta narxlari "+params.price+" dan boshlanadi. Yandex xizmatlari reyslarga doir kechikishlar, bekor qilinishlar va boshqa oʻzgarishlarni hisobga olgan holda parvozlar va qoʻnishlar jadvalini koʻrsatadi hamda koʻplab sotuvchilardan aviachiptalar narxiga oid axborotlarni toʻplab, aviachiptalarni arzon  narxlarda xarid qilishga yordam beradi.";},
        "text-suburban": function(params){return "Bugun, ertaga va barcha kunlar uchun "+params.from.title+" – "+params.to.title+" marshrutidagi elektr poyezdlar jadvali barcha oʻzgarishlar va bekor qilishlar bilan. Eng tezkor "+params.from.title+" – "+params.to.title+" elektr poyezdi "+params.duration+" ichida yetib boradi. Yandex.Jadvallar elektr poyezdlarning harakat grafigini bekor qilish va boshqa oʻzgarishlarni hisobga olgan holda namoyish qiladi.";},
        "text-suburban-lastochki": function(params){return "Bugun, ertaga va barcha kunlar uchun "+params.from.title+" – "+params.to.title+" marshrutidagi elektr poyezdlar va “Lastochka”lar jadvali barcha oʻzgarishlar va bekor qilishlar bilan. Eng tezkor "+params.from.title+" – "+params.to.title+" elektr poyezdi "+params.duration+" ichida yetib boradi. Yandex.Jadvallar elektr poyezdlarining harakat grafigini bekor qilish va boshqa oʻzgarishlarni hisobga olgan holda namoyish qiladi.";},
        "text-suburban-price": function(params){return "Bugun, ertaga va barcha kunlar uchun "+params.from.title+" – "+params.to.title+" marshrutidagi elektr poyezdlar jadvali barcha oʻzgarishlar va bekor qilishlar bilan. Eng tezkor "+params.from.title+" – "+params.to.title+" elektr poyezdi "+params.duration+" ichida yetib boradi. Butun tarif boʻyicha chipta narxi "+params.price+" dan boshlanadi. Yandex.Jadvallar elektr poyezdlarining harakat grafigini bekor qilish va boshqa oʻzgarishlarni hisobga olgan holda namoyish qiladi.";},
        "text-suburban-price-lastochki": function(params){return "Bugun, ertaga va barcha kunlar uchun "+params.from.title+" – "+params.to.title+" marshrutidagi elektr poyezdlar va “Lastochka”lar jadvali barcha oʻzgarishlar va bekor qilishlar bilan. Eng tezkor "+params.from.title+" – "+params.to.title+" elektr poyezdi "+params.duration+" ichida yetib boradi. Butun tarif boʻyicha chipta narxi "+params.price+" dan boshlanadi. Yandex.Jadvallar elektr poyezdlarining harakat grafigini bekor qilish va boshqa oʻzgarishlarni hisobga olgan holda namoyish qiladi.";},
        "text-train": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-train-price": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Цена билета "+params.trainClassesWithPrices+". Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-train-price-subtypes": function(params){return "Расписание поездов "+params.from.title+" — "+params.to.title+" со всеми изменениями"+(params.isForeignSearch?"":" от РЖД, "+params.year+" год")+". Стоимость билетов, покупка ж/д билетов онлайн. Билеты на "+plural({"count":params.subtypesCount,"one":"поезд","some":"поезда","many":"поезда"})+" "+params.subtypesWithPrices+". Цена билета "+params.trainClassesWithPrices+". Время в пути на поезде от "+params.duration+". Купить билет на поезд онлайн, чтобы не стоять в очереди у кассы.";},
        "text-water": function(params){return "Eng tezkor teploxod "+params.from.title+" – "+params.to.title+" marshrutini "+params.duration+" ichida suzib oʻtadi. Yandex.Jadvallar xizmatida kemalarning suzish grafigi va pristanlar boʻyicha jadvalni topish mumkin.";},
        "text-water-price": function(params){return "Eng tezkor teploxod "+params.from.title+" – "+params.to.title+" marshrutini "+params.duration+" ichida suzib oʻtadi. Chipta narxi "+params.price+" dan boshlanadi. Yandex.Jadvallar xizmatida kemalarning suzish grafigi va pristanlar boʻyicha jadvalni topish mumkin.";},
        "title-all": function(params){return params.from.title+" – "+params.to.title+" transport jadvali: "+params.transportTypes;},
        "title-bus": function(params){return params.from.title+" – "+params.to.title+" avtobuslar jadvali, chipta narxlari, chiptani onlayn  xarid qilish";},
        "title-lastochka": function(params){return "Расписание электричек «Ласточка» "+params.from.title+" – "+params.to.title+" с изменениями, цена билетов";},
        "title-plane": function(params){return params.from.title+" – "+params.to.title+" samolyotlar jadvali, chipta narxlari, chiptani onlayn xarid qilish";},
        "title-suburban": function(params){return params.from.title+" – "+params.to.title+" elektr poyezdlar jadvali oʻzgarishlar bilan, chiptalar narxi";},
        "title-train": function(params){return "Поезда "+params.from.title+" — "+params.to.title+": расписание, цены и ж/д билеты";},
        "title-water": function(params){return "Teploxodlar jadvali: "+params.from.title+" – "+params.to.title;},
        "type-bus": "avtobusga",
        "type-plane": "samolyotga",
        "type-suburban": "elektr poyezdga",
        "type-train": "poyezdga",
        "type-water": "paroxodga"
    }
});
