import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "station-plane-seo",
    data: {
        "ask-for-information-phones": "уточняйте по справочным телефонам",
        "contact-information-phones": "обращайтесь по справочным телефонам",
        "description-arrival": function(params){return "Онлайн-табло прилёта рейсов в аэропорт "+params.airportTitle+" ("+params.airportCode+"). Расписание на сегодня и завтра, статус рейса в реальном времени, информация о задержках и отменах.";},
        "description-departure": function(params){return "Онлайн-табло вылета рейсов из аэропорта "+params.airportTitle+" ("+params.airportCode+"). Расписание на сегодня и завтра, статус рейса в реальном времени, информация о задержках и отменах.";},
        "description-with-terminal-arrival": function(params){return "Онлайн-табло прилёта рейсов "+(params.isDomestic?"во внутренний ":"")+(params.isInternational?"в международный ":"")+(params.noSign?"в ":"")+"терминал "+params.terminal+" аэропорта "+params.airportTitle+". Расписание на сегодня и завтра, статус рейса в реальном времени, информация о задержках и отменах.";},
        "description-with-terminal-departure": function(params){return "Онлайн-табло вылета рейсов из "+(params.isDomestic?"внутреннего ":"")+(params.isInternational?"международного ":"")+"терминала "+params.terminal+" аэропорта "+params.airportTitle+". Расписание на сегодня и завтра, статус рейса в реальном времени, информация о задержках и отменах.";},
        "disclaimer-arrival-first-part": function(params){return "Расписание прилёта самолётов в аэропорт "+params.airportTitle+(params.today?" на сегодня":"")+(params.date?", ":"")+params.date+".";},
        "disclaimer-arrival-with-terminal-first-part": function(params){return "Расписание прилёта самолётов "+(params.isDomestic?"во внутренний ":"")+(params.isInternational?"в международный ":"")+(params.noSign?"в ":"")+"терминал "+params.terminal+" аэропорта "+params.airportTitle+" на "+params.date+". На сервисе Яндекс Расписания можно узнать время отправления на сегодня и завтра, статус рейса в реальном времени, информацию о задержке и отмене рейсов.";},
        "disclaimer-departure-first-part": function(params){return "Расписание вылета самолётов из аэропорта "+params.airportTitle+(params.today?" на сегодня":"")+(params.date?", ":"")+params.date+".";},
        "disclaimer-departure-with-terminal-first-part": function(params){return "Расписание вылета самолётов из "+(params.isDomestic?"внутреннего ":"")+(params.isInternational?"международного ":"")+"терминала "+params.terminal+" аэропорта "+params.airportTitle+" на "+params.date+". На сервисе Яндекс Расписания можно узнать время отправления на сегодня и завтра, статус рейса в реальном времени, информацию о задержке и отмене рейсов.";},
        "disclaimer-fourth-part": function(params){return "Дополнительную информацию по текущим статусам рейсов, отменам и опозданиям "+params.askForInformationPhonesText+" или на официальном сайте аэропорта.";},
        "disclaimer-second-part-list": "На сервисе Яндекс Расписания есть подробная информация о перелетах авиакомпаний:",
        "disclaimer-second-part-list-item-1": "– статус рейса в реальном времени",
        "disclaimer-second-part-list-item-2": "– время отправления и прибытия на сегодня и завтра",
        "disclaimer-second-part-list-item-3": "– задержка и отмена рейсов",
        "disclaimer-second-part-list-item-4": "– терминал отправления и номер стойки регистрации",
        "disclaimer-third-part": "Вы можете отобразить на странице только нужные вам рейсы: для этого введите в поле фильтра номер рейса, город или авиакомпанию.",
        "disclaimer-with-terminal-second-part": function(params){return "По всем дополнительным вопросам, связанным с перелетами аэропорта "+params.contactInformationPhonesText+" или уточняйте информацию на официальном сайте.";},
        "h1-arrival-different-names": function(params){return "Аэропорт "+params.airportTitle+(params.cityTitle?" ("+params.cityTitle+")":"")+": онлайн-табло прилёта";},
        "h1-arrival-same-names": function(params){return "Аэропорт "+params.airportTitle+": онлайн-табло прилёта";},
        "h1-departure-different-names": function(params){return "Аэропорт "+params.airportTitle+(params.cityTitle?" ("+params.cityTitle+")":"")+": онлайн-табло вылета";},
        "h1-departure-same-names": function(params){return "Аэропорт "+params.airportTitle+": онлайн-табло вылета";},
        "h1-with-terminal-arrival-different-names": function(params){return "Аэропорт "+params.airportTitle+(params.cityTitle?" ("+params.cityTitle+")":"")+", терминал "+params.terminal+": онлайн-табло прилёта";},
        "h1-with-terminal-arrival-same-names": function(params){return "Аэропорт "+params.airportTitle+", терминал "+params.terminal+": онлайн-табло прилёта";},
        "h1-with-terminal-departure-different-names": function(params){return "Аэропорт "+params.airportTitle+(params.cityTitle?" ("+params.cityTitle+")":"")+", терминал "+params.terminal+": онлайн-табло вылета";},
        "h1-with-terminal-departure-same-names": function(params){return "Аэропорт "+params.airportTitle+", терминал "+params.terminal+": онлайн-табло вылета";},
        "title-arrival-different-names": function(params){return "Табло аэропорта "+params.airportTitle+(params.cityTitle?" ("+params.cityTitle+")":"")+". Прибытие – Яндекс Расписания";},
        "title-arrival-same-names": function(params){return "Табло аэропорта "+params.airportTitle+". Прибытие – Яндекс Расписания";},
        "title-departure-different-names": function(params){return "Табло аэропорта "+params.airportTitle+(params.cityTitle?" ("+params.cityTitle+")":"")+". Отправление – Яндекс Расписания";},
        "title-departure-same-names": function(params){return "Табло аэропорта "+params.airportTitle+". Отправление – Яндекс Расписания";},
        "title-with-terminal-arrival-different-names": function(params){return "Табло аэропорта "+params.airportTitle+(params.cityTitle?" ("+params.cityTitle+")":"")+", терминал "+params.terminal+". Прибытие – Яндекс Расписания";},
        "title-with-terminal-arrival-same-names": function(params){return "Табло аэропорта "+params.airportTitle+", терминал "+params.terminal+". Прибытие – Яндекс Расписания";},
        "title-with-terminal-departure-different-names": function(params){return "Табло аэропорта "+params.airportTitle+(params.cityTitle?" ("+params.cityTitle+")":"")+", терминал "+params.terminal+". Отправление – Яндекс Расписания";},
        "title-with-terminal-departure-same-names": function(params){return "Табло аэропорта "+params.airportTitle+", терминал "+params.terminal+". Отправление – Яндекс Расписания";}
    }
});
