import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "station",
    data: {
        "aeroexpress": "Аэроэкспресс",
        "aeroexpress-text": function(params){return params.airportName+" аэроэкспресі";},
        "all-directions": "Барлық бағыттар",
        "all-terminals": "Все терминалы",
        "all-times": "Любое время",
        "arrival": "Келуі",
        "arrival-plane": "Ұшып келуі",
        "city-stations": function(params){return params.cityTitleGenitive+" бекеттері";},
        "date-arrival-all-days-plane": "Прилет, все дни",
        "date-arrival-all-days-train": "Прибытие, все дни",
        "date-departure-all-days-plane": "Вылет, все дни",
        "date-departure-all-days-train": "Отправление, все дни",
        "date-mobile-arrival-plane": function(params){return "Прилет "+params.date+", "+params.dayOfWeek;},
        "date-mobile-arrival-train": function(params){return "Прибытие "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-bus": function(params){return "Отправление "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-plane": function(params){return "Вылет "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-train": function(params){return "Отправление "+params.date+", "+params.dayOfWeek;},
        "departure": "Жөнелтуі",
        "departure-plane": "Ұшып кету",
        "disclaimer-bus": function(params){return params.title+": расписание пригородных и междугородних автобусов на "+((params.whenSpecial=="today")?"сегодня":"")+((params.whenSpecial=="tomorrow")?"завтра":"")+((params.whenSpecial=="all-days")?"все дни":"")+(params.whenDate?(params.whenSpecial?", ":"")+params.whenDate:"")+". На странице можно отобразить только нужные вам рейсы: для этого введите в поле фильтра номер маршрута или станцию назначения.";},
        "disclaimer-bus-attention": "Внимание! В расписании показаны рейсы автобусов, доступные нашему сервису. Каких-то рейсов может не быть в расписании, потому что перевозчик не передал нам информацию о них. Кроме того, перевозчики не всегда сообщают об изменениях цен на проезд, поэтому советуем перед поездкой позвонить %%на автостанцию%% или перевозчику и уточнить детали.",
        "disclaimer-suburban": function(params){return params.title+" бойынша электричкалардың "+params.year+" жылға "+params.date+" өзгертулер енгізілген кестесі. Түн ортасынан кейін жөнелтілетін қала маңы пойыздарының жүру күндері мен өзгерту күндері жаңа тәуліктерге жатқызылады.\nЭлектр пойызы қозғалысының барлық аялдамалары көрсетілген егжей-тегжейлі бағдарын көру үшін рейсті таңдаңыз.";},
        "disclaimer-suburban-all-days": function(params){return "Электричкалардың "+params.title+" бойынша өзгерістер енгізілген кестесі.\nЭлектр пойызы қозғалысының барлық аялдамалары көрсетілген егжей-тегжейлі бағдарын көру үшін рейсті таңдаңыз.";},
        "disclaimer-tablo": function(params){return "Расписание движения поездов дальнего следования и электричек от "+params.titleGenitive+" на "+params.year+" год с учетом изменений. Даты изменения и дни курсирования поездов, отправляющихся после полуночи, относятся к новым суткам. Чтобы узнать цену билета на поезда РЖД, выберите станции отправления и назначения.";},
        "disclaimer-tablo-title": function(params){return "Онлайн-табло по "+params.titleDative;},
        "disclaimer-tablo-title-popular": function(params){return "Онлайн-табло "+params.titleGenitive;},
        "disclaimer-train": function(params){return params.titleGenitive+" жылдан "+params.year+" жылға алысқа жүретін пойыздар қозғалысының өзгерістері есепке алынған кестесі. Түн ортасынан кейін жөнелтілетін пойыздардың жүру күндері мен өзгерту күндері жаңа тәуліктерге жатқызылады. \n РЖД пойыздарына билет бағасын білу үшін жөнелту және межелі бекеттерді таңдаңыз.";},
        "disclaimer-train-title": function(params){return params.titleDative+" бойынша онлайн-табло.";},
        "disclaimer-train-title-popular": function(params){return params.titleGenitive+" онлайн-табло.";},
        "disclaimer-water": function(params){return "Онлайн табло "+params.titleGenitive+" с расписанием теплоходов, паромов, речных трамвайчиков, катеров и другого водного транспорта на "+params.year+" год.";},
        "except": "кроме",
        "hide-gone": function(params){return "Кеткендерді көрсетпеу ("+params.count+")";},
        "hide-gone-arrival": function(params){return "Келгендерді көрсетпеу ("+params.count+")";},
        "hide-gone-suburban": function(params){return "Кеткен ("+params.count+plural({"count":params.count,"one":"электричканы","some":"электричканы","many":"электричканы"})+") жасыру";},
        "hide-gone-suburban-arrival": function(params){return "Келген ("+params.count+plural({"count":params.count,"one":"электричканы","some":"электричканы","many":"электричканы"})+") жасыру";},
        "hide-gone-train": function(params){return "Кеткен ("+params.count+plural({"count":params.count,"one":"пойызды","some":"пойызды","many":"пойызды"})+") жасыру";},
        "hide-gone-train-arrival": function(params){return "Келген ("+params.count+plural({"count":params.count,"one":"пойызды","some":"пойызды","many":"пойызды"})+") жасыру";},
        "informer-link": "Разместить расписание на своём сайте",
        "interval-thread-time": function(params){return "С "+params.beginTime+" до "+params.endTime;},
        "local-time-disclaimer": "Жергілікті уақыт көрсетілген",
        "map-default-text": "Картадан қарау",
        "more-directions": "Тағы",
        "next": "далее",
        "no-info": "Яндекс.Кестелерде бұл бекетте тоқтайтын рейстер туралы мәліметтер жоқ.",
        "no-threads-bus": "У Яндекс.Расписаний нет информации о рейсах с остановкой на этой станции.",
        "no-threads-default": "Берілген іздеу параметрлері бойынша рейстер туралы ақпарат жоқ.",
        "no-threads-for-filter": "Бұл сұрыптама бойынша ештеңе табылмады",
        "no-threads-suburban-arrival-on-all-days": "Осы бекетке келетін қала маңы пойыздары (электричкалар) туралы ақпарат жоқ.",
        "no-threads-suburban-arrival-on-date": function(params){return params.date+" келетін қала маңы пойыздары (электричкалар) туралы ақпарат жоқ.";},
        "no-threads-suburban-departure-on-all-days": "Осы бекеттен жөнелтілетін қала маңы пойыздары (электричкалар) туралы ақпарат жоқ.",
        "no-threads-suburban-departure-on-date": function(params){return params.date+" күні жөнелтілетін қала маңы пойыздары (электричкалар) туралы ақпарат жоқ.";},
        "no-threads-train-arrival-on-all-days": "Бұл бекетке келетін пойыздар туралы ақпарат жоқ.",
        "no-threads-train-arrival-on-date": function(params){return params.date+" күні келетін пойыздар туралы ақпарат жоқ.";},
        "no-threads-train-departure-on-all-days": "Бұл бекеттен жөнелтілетін пойыздар туралы ақпарат жоқ.",
        "no-threads-train-departure-on-date": function(params){return params.date+" күні жөнелтілетін пойыздар туралы ақпарат жоқ.";},
        "page-subtype-suburban": "Электричкалар",
        "page-subtype-tablo": "Все табло",
        "page-subtype-train": "Пойыздар",
        "popular-directions": "Ең көп жүретін бағыттар",
        "popular-directions-water": "Быстрый поиск маршрута",
        "print": "Басып шығару",
        "schedule-for-print": function(params){return "Расписание на "+params.date;},
        "schedule-for-print-on-all-days": "Расписание на все дни",
        "schedule-on-all-days": "барлық күндердің кестесі",
        "schedule-on-date": function(params){return params.date+" күніне кесте";},
        "schedule-on-time": function(params){return "Расписание с "+params.min+" до "+params.max;},
        "schedule-on-today": "Расписание на сегодня",
        "schedule-on-tomorrow": "Ертеңге арналған кесте",
        "schedule-suburban": "қала маңы пойыздарының (электричкалардың) кестесі",
        "schedule-train": "алысқа жүретін пойыздардың кестесі",
        "scheduleAllDays": "Барлық күндерге",
        "scheduleToday": "Бүгін",
        "scheduleTomorrow": "Ертең",
        "search-default": "Қала немесе бекет",
        "search-plane": "Рейс нөмірі, қала немесе әуе компаниясы",
        "search-station-header": "Поиск станции",
        "search-station-not-found": "По данному фильтру станций не найдено",
        "search-station-placeholder": "Остановка или населенный пункт",
        "search-suburban": "Қала, бекет немесе электричканың нөмірі",
        "search-train": "Қала, бекет немесе пойыздың нөмірі",
        "show-all-bus-stations": "Все автовокзалы",
        "show-gone": function(params){return "Кеткендерді көрсету ("+params.count+")";},
        "show-gone-arrival": function(params){return "Келгендерді көрсету ("+params.count+")";},
        "show-gone-suburban": function(params){return "Кеткен ("+params.count+plural({"count":params.count,"one":"электричканы","some":"электричканы","many":"электричканы"})+") көрсету";},
        "show-gone-suburban-arrival": function(params){return "Келген ("+params.count+plural({"count":params.count,"one":"электричканы","some":"электричканы","many":"электричканы"})+") көрсету";},
        "show-gone-train": function(params){return "Кеткен ("+params.count+plural({"count":params.count,"one":"пойызды","some":"пойызды","many":"пойызды"})+") көрсету";},
        "show-gone-train-arrival": function(params){return "Келген ("+params.count+plural({"count":params.count,"one":"пойызды","some":"пойызды","many":"пойызды"})+") көрсету";},
        "stops-everywhere": "Барлық аялдамалармен",
        "stops-nonstop": "Аялдамасыз",
        "stops-stops": "Аялдамалар:",
        "terminal": function(params){return "Терминал "+params.terminalName;},
        "time": "Время",
        "title-bus": function(params){return "Расписание автобусов: "+params.title;},
        "title-suburban": function(params){return params.titleDative+" бойынша электричкалар кестесі";},
        "title-suburban-no-city": function(params){return "Электричкалар кестесі: "+params.title;},
        "title-suburban-popular": function(params){return "Электричкалар кестесі: "+params.title+" ("+params.cityName+")";},
        "title-suburban-popular-no-city": function(params){return "Электричкалар кестесі: "+params.title;},
        "title-tablo": function(params){return "Расписание поездов и электричек по "+params.titleDative;},
        "title-tablo-no-city": function(params){return "Расписание поездов и электричек: "+params.title;},
        "title-tablo-popular": function(params){return "Расписание поездов и электричек: "+params.title+" ("+params.cityName+")";},
        "title-tablo-popular-no-city": function(params){return "Расписание поездов и электричек: "+params.title;},
        "title-train": function(params){return params.titleDative+" бойынша пойыздар кестесі";},
        "title-train-no-city": function(params){return "Пойыздар кестесі: "+params.title;},
        "title-train-popular": function(params){return "Пойыздар кестесі: "+params.title+" ("+params.cityName+")";},
        "title-train-popular-no-city": function(params){return "Пойыздар кестесі: "+params.title;},
        "title-unknown": function(params){return params.titleDative+" бойынша кесте";},
        "title-water": function(params){return params.title+": расписание теплоходов";},
        "to-arrival-train-link": function(params){return params.title+": прибытие поездов";},
        "to-departure-train-link": function(params){return params.title+": отправление поездов";},
        "to-station": function(params){return "До остановки: "+params.title;},
        "to-station-short": function(params){return "До остановки "+params.title;},
        "transport-link-text-suburban": "Электричкалар кестесі",
        "transport-link-text-train": "Пойыздар кестесі",
        "try-view-schedule": "Қарап көріңіз: ",
        "type-bus": "Автобекеттер",
        "type-plane": "Әуежайлар",
        "type-train": "Сапаржайлар мен бекеттер",
        "type-water": "Водный транспорт"
    }
});
