import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "station",
    data: {
        "aeroexpress": "Аэроэкспресс",
        "aeroexpress-text": function(params){return "Аэроэкспресс "+params.airportName;},
        "all-directions": "Все направления",
        "all-terminals": "Все терминалы",
        "all-times": "Любое время",
        "arrival": "Прибытие",
        "arrival-plane": "Прилет",
        "city-stations": function(params){return "Станции "+params.cityTitleGenitive;},
        "date-arrival-all-days-plane": "Прилет, все дни",
        "date-arrival-all-days-train": "Прибытие, все дни",
        "date-departure-all-days-plane": "Вылет, все дни",
        "date-departure-all-days-train": "Отправление, все дни",
        "date-mobile-arrival-plane": function(params){return "Прилет "+params.date+", "+params.dayOfWeek;},
        "date-mobile-arrival-train": function(params){return "Прибытие "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-bus": function(params){return "Отправление "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-plane": function(params){return "Вылет "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-train": function(params){return "Отправление "+params.date+", "+params.dayOfWeek;},
        "departure": "Отправление",
        "departure-plane": "Вылет",
        "disclaimer-bus": function(params){return params.title+": расписание пригородных и междугородних автобусов на "+((params.whenSpecial=="today")?"сегодня":"")+((params.whenSpecial=="tomorrow")?"завтра":"")+((params.whenSpecial=="all-days")?"все дни":"")+(params.whenDate?(params.whenSpecial?", ":"")+params.whenDate:"")+". На странице можно отобразить только нужные вам рейсы: для этого введите в поле фильтра номер маршрута или станцию назначения.";},
        "disclaimer-bus-attention": "Внимание! В расписании показаны рейсы автобусов, доступные нашему сервису. Каких-то рейсов может не быть в расписании, потому что перевозчик не передал нам информацию о них. Кроме того, перевозчики не всегда сообщают об изменениях цен на проезд, поэтому советуем перед поездкой позвонить %%на автостанцию%% или перевозчику и уточнить детали.",
        "disclaimer-suburban": function(params){return "Расписание электричек по "+params.title+" на "+params.year+" год с учетом изменений "+params.date+". Даты изменения и дни курсирования пригородных поездов, отправляющихся после полуночи, относятся к новым суткам.\nЧтобы посмотреть подробный маршрут движения электропоезда со всеми остановками, выберите рейс.";},
        "disclaimer-suburban-all-days": function(params){return "Расписание электричек по "+params.title+" с учетом изменений.\nЧтобы посмотреть подробный маршрут движения электропоезда со всеми остановками, выберите рейс.";},
        "disclaimer-tablo": function(params){return "Расписание движения поездов дальнего следования и электричек от "+params.titleGenitive+" на "+params.year+" год с учетом изменений. Даты изменения и дни курсирования поездов, отправляющихся после полуночи, относятся к новым суткам. Чтобы узнать цену билета на поезда РЖД, выберите станции отправления и назначения.";},
        "disclaimer-tablo-title": function(params){return "Онлайн-табло по "+params.titleDative;},
        "disclaimer-tablo-title-popular": function(params){return "Онлайн-табло "+params.titleGenitive;},
        "disclaimer-train": function(params){return "Расписание движения поездов дальнего следования от "+params.titleGenitive+" на "+params.year+" год с учетом изменений. Даты изменения и дни курсирования поездов, отправляющихся после полуночи, относятся к новым суткам.\nЧтобы узнать цену билета на поезда РЖД, выберите станции отправления и назначения.";},
        "disclaimer-train-title": function(params){return "Онлайн-табло по "+params.titleDative+".";},
        "disclaimer-train-title-popular": function(params){return "Онлайн-табло "+params.titleGenitive+".";},
        "disclaimer-water": function(params){return "Онлайн табло "+params.titleGenitive+" с расписанием теплоходов, паромов, речных трамвайчиков, катеров и другого водного транспорта на "+params.year+" год.";},
        "except": "кроме",
        "hide-gone": function(params){return "Скрыть ушедшие ("+params.count+")";},
        "hide-gone-arrival": function(params){return "Скрыть пришедшие ("+params.count+")";},
        "hide-gone-suburban": function(params){return "Скрыть ушедшие ("+params.count+" "+plural({"count":params.count,"one":"электричка","some":"электрички","many":"электричек"})+")";},
        "hide-gone-suburban-arrival": function(params){return "Скрыть пришедшие ("+params.count+" "+plural({"count":params.count,"one":"электричка","some":"электрички","many":"электричек"})+")";},
        "hide-gone-train": function(params){return "Скрыть ушедшие ("+params.count+" "+plural({"count":params.count,"one":"поезд","some":"поезда","many":"поездов"})+")";},
        "hide-gone-train-arrival": function(params){return "Скрыть пришедшие ("+params.count+" "+plural({"count":params.count,"one":"поезд","some":"поезда","many":"поездов"})+")";},
        "informer-link": "Разместить расписание на своём сайте",
        "interval-thread-time": function(params){return "С "+params.beginTime+" до "+params.endTime;},
        "local-time-disclaimer": "Указано местное время",
        "map-default-text": "Посмотреть на карте",
        "more-directions": "Ещё",
        "next": "далее",
        "no-info": "У Яндекс.Расписаний нет сведений о рейсах, останавливающихся на этой станции.",
        "no-threads-bus": "У Яндекс.Расписаний нет информации о рейсах с остановкой на этой станции.",
        "no-threads-default": "Нет информации о рейсах для данных параметров поиска.",
        "no-threads-for-filter": "По данному фильтру ничего не найдено",
        "no-threads-suburban-arrival-on-all-days": "Нет информации о пригородных поездах (электричках), прибывающих на данную станцию.",
        "no-threads-suburban-arrival-on-date": function(params){return "Нет информации о пригородных поездах (электричках), прибывающих "+params.date+".";},
        "no-threads-suburban-departure-on-all-days": "Нет информации о пригородных поездах (электричках), отправляющихся с данной станции.",
        "no-threads-suburban-departure-on-date": function(params){return "Нет информации о пригородных поездах (электричках), отправляющихся "+params.date+".";},
        "no-threads-train-arrival-on-all-days": "Нет информации о поездах, прибывающих на данную станцию.",
        "no-threads-train-arrival-on-date": function(params){return "Нет информации о поездах, прибывающих "+params.date+".";},
        "no-threads-train-departure-on-all-days": "Нет информации о поездах, отправляющихся с данной станции.",
        "no-threads-train-departure-on-date": function(params){return "Нет информации о поездах, отправляющихся "+params.date+".";},
        "page-subtype-suburban": "Электрички",
        "page-subtype-tablo": "Все табло",
        "page-subtype-train": "Поезда",
        "popular-directions": "Популярные направления",
        "popular-directions-water": "Быстрый поиск маршрута",
        "print": "Распечатать",
        "schedule-for-print": function(params){return "Расписание на "+params.date;},
        "schedule-for-print-on-all-days": "Расписание на все дни",
        "schedule-on-all-days": "расписание на все дни",
        "schedule-on-date": function(params){return "Расписание на "+params.date;},
        "schedule-on-time": function(params){return "Расписание с "+params.min+" до "+params.max;},
        "schedule-on-today": "Расписание на сегодня",
        "schedule-on-tomorrow": "Расписание на завтра",
        "schedule-suburban": "расписание пригородных поездов (электричек)",
        "schedule-train": "расписание поездов дальнего следования",
        "scheduleAllDays": "На все дни",
        "scheduleToday": "Сегодня",
        "scheduleTomorrow": "Завтра",
        "search-default": "Город или станция",
        "search-plane": "Номер рейса, город или авиакомпания",
        "search-station-header": "Поиск станции",
        "search-station-not-found": "По данному фильтру станций не найдено",
        "search-station-placeholder": "Остановка или населенный пункт",
        "search-suburban": "Город, станция или номер электрички",
        "search-train": "Город, станция или номер поезда",
        "show-all-bus-stations": "Все автовокзалы",
        "show-gone": function(params){return "Показать ушедшие ("+params.count+")";},
        "show-gone-arrival": function(params){return "Показать пришедшие ("+params.count+")";},
        "show-gone-suburban": function(params){return "Показать ушедшие ("+params.count+" "+plural({"count":params.count,"one":"электричка","some":"электрички","many":"электричек"})+")";},
        "show-gone-suburban-arrival": function(params){return "Показать пришедшие ("+params.count+" "+plural({"count":params.count,"one":"электричка","some":"электрички","many":"электричек"})+")";},
        "show-gone-train": function(params){return "Показать ушедшие ("+params.count+" "+plural({"count":params.count,"one":"поезд","some":"поезда","many":"поездов"})+")";},
        "show-gone-train-arrival": function(params){return "Показать пришедшие ("+params.count+" "+plural({"count":params.count,"one":"поезд","some":"поезда","many":"поездов"})+")";},
        "stops-everywhere": "Со всеми остановками",
        "stops-nonstop": "Без остановок",
        "stops-stops": "Остановки:",
        "terminal": function(params){return "Терминал "+params.terminalName;},
        "time": "Время",
        "title-bus": function(params){return "Расписание автобусов: "+params.title;},
        "title-suburban": function(params){return "Расписание электричек по "+params.titleDative;},
        "title-suburban-no-city": function(params){return "Расписание электричек: "+params.title;},
        "title-suburban-popular": function(params){return "Расписание электричек: "+params.title+" ("+params.cityName+")";},
        "title-suburban-popular-no-city": function(params){return "Расписание электричек: "+params.title;},
        "title-tablo": function(params){return "Расписание поездов и электричек по "+params.titleDative;},
        "title-tablo-no-city": function(params){return "Расписание поездов и электричек: "+params.title;},
        "title-tablo-popular": function(params){return "Расписание поездов и электричек: "+params.title+" ("+params.cityName+")";},
        "title-tablo-popular-no-city": function(params){return "Расписание поездов и электричек: "+params.title;},
        "title-train": function(params){return "Расписание поездов по "+params.titleDative;},
        "title-train-no-city": function(params){return "Расписание поездов: "+params.title;},
        "title-train-popular": function(params){return "Расписание поездов: "+params.title+" ("+params.cityName+")";},
        "title-train-popular-no-city": function(params){return "Расписание поездов: "+params.title;},
        "title-unknown": function(params){return "Расписание по "+params.titleDative;},
        "title-water": function(params){return params.title+": расписание теплоходов";},
        "to-arrival-train-link": function(params){return params.title+": прибытие поездов";},
        "to-departure-train-link": function(params){return params.title+": отправление поездов";},
        "to-station": function(params){return "До остановки: "+params.title;},
        "to-station-short": function(params){return "До остановки "+params.title;},
        "transport-link-text-suburban": "Расписание электричек",
        "transport-link-text-train": "Расписание поездов",
        "try-view-schedule": "Попробуйте посмотреть: ",
        "type-bus": "Автовокзалы",
        "type-plane": "Аэропорты",
        "type-train": "Вокзалы и станции",
        "type-water": "Водный транспорт"
    }
});
