import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "station",
    data: {
        "aeroexpress": "Аероекспрес",
        "aeroexpress-text": function(params){return "Аероекспрес "+params.airportName;},
        "all-directions": "Усі напрямки",
        "all-terminals": "Все терминалы",
        "all-times": "Любое время",
        "arrival": "Прибуття",
        "arrival-plane": "Приліт",
        "city-stations": function(params){return "Станції "+params.cityTitleGenitive;},
        "date-arrival-all-days-plane": "Прилет, все дни",
        "date-arrival-all-days-train": "Прибытие, все дни",
        "date-departure-all-days-plane": "Вылет, все дни",
        "date-departure-all-days-train": "Отправление, все дни",
        "date-mobile-arrival-plane": function(params){return "Прилет "+params.date+", "+params.dayOfWeek;},
        "date-mobile-arrival-train": function(params){return "Прибытие "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-bus": function(params){return "Отправление "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-plane": function(params){return "Вылет "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-train": function(params){return "Отправление "+params.date+", "+params.dayOfWeek;},
        "departure": "Відправлення",
        "departure-plane": "Виліт",
        "disclaimer-bus": function(params){return params.title+": расписание пригородных и междугородних автобусов на "+((params.whenSpecial=="today")?"сегодня":"")+((params.whenSpecial=="tomorrow")?"завтра":"")+((params.whenSpecial=="all-days")?"все дни":"")+(params.whenDate?(params.whenSpecial?", ":"")+params.whenDate:"")+". На странице можно отобразить только нужные вам рейсы: для этого введите в поле фильтра номер маршрута или станцию назначения.";},
        "disclaimer-bus-attention": "Внимание! В расписании показаны рейсы автобусов, доступные нашему сервису. Каких-то рейсов может не быть в расписании, потому что перевозчик не передал нам информацию о них. Кроме того, перевозчики не всегда сообщают об изменениях цен на проезд, поэтому советуем перед поездкой позвонить %%на автостанцию%% или перевозчику и уточнить детали.",
        "disclaimer-suburban": function(params){return "Розклад електричок по "+params.title+" на "+params.year+" рік з урахуванням змін "+params.date+". Дати змінення та дні курсування приміських потягів, що відправляються після півночі, належать до нової доби.\nЩоб переглянути детальний маршрут руху електропоїзда з усіма зупинками, виберіть рейс.";},
        "disclaimer-suburban-all-days": function(params){return "Розклад електричок по "+params.title+" з урахуванням змін.\nЩоб переглянути детальний маршрут руху електропоїзда з усіма зупинками, виберіть рейс.";},
        "disclaimer-tablo": function(params){return "Расписание движения поездов дальнего следования и электричек от "+params.titleGenitive+" на "+params.year+" год с учетом изменений. Даты изменения и дни курсирования поездов, отправляющихся после полуночи, относятся к новым суткам. Чтобы узнать цену билета на поезда РЖД, выберите станции отправления и назначения.";},
        "disclaimer-tablo-title": function(params){return "Онлайн-табло по "+params.titleDative;},
        "disclaimer-tablo-title-popular": function(params){return "Онлайн-табло "+params.titleGenitive;},
        "disclaimer-train": function(params){return "Розклад руху потягів далекого сполучення від "+params.titleGenitive+" на "+params.year+" рік з урахуванням змін. Дати змінення та дні курсування приміських потягів, що відправляються після півночі, належать до нової доби.\nЩоб дізнатися ціну квитка на потяги «Російські залізниці», виберіть станції відправлення та призначення.";},
        "disclaimer-train-title": function(params){return "Онлайн-табло по "+params.titleDative+".";},
        "disclaimer-train-title-popular": function(params){return "Онлайн-табло "+params.titleGenitive+".";},
        "disclaimer-water": function(params){return "Онлайн табло "+params.titleGenitive+" с расписанием теплоходов, паромов, речных трамвайчиков, катеров и другого водного транспорта на "+params.year+" год.";},
        "except": "кроме",
        "hide-gone": function(params){return "Приховати ті, що відправилися ("+params.count+")";},
        "hide-gone-arrival": function(params){return "Приховати ті, що прибули ("+params.count+")";},
        "hide-gone-suburban": function(params){return "Приховати ті, що відправилися ("+params.count+" "+plural({"count":params.count,"one":"электричка","some":"электрички","many":"электричек"})+")";},
        "hide-gone-suburban-arrival": function(params){return "Приховати ті, що прибули ("+params.count+" "+plural({"count":params.count,"one":"электричка","some":"электрички","many":"электричек"})+")";},
        "hide-gone-train": function(params){return "Приховати ті, що відправилися ("+params.count+" "+plural({"count":params.count,"one":"поезд","some":"поезда","many":"поездов"})+")";},
        "hide-gone-train-arrival": function(params){return "Приховати ті, що прибули ("+params.count+" "+plural({"count":params.count,"one":"поезд","some":"поезда","many":"поездов"})+")";},
        "informer-link": "Разместить расписание на своём сайте",
        "interval-thread-time": function(params){return "С "+params.beginTime+" до "+params.endTime;},
        "local-time-disclaimer": "Вказано місцевий час",
        "map-default-text": "Переглянути на карті",
        "more-directions": "Ще",
        "next": "далее",
        "no-info": "У Яндекс.Розкладів немає даних щодо рейсів, що зупиняються на цій станції.",
        "no-threads-bus": "У Яндекс.Расписаний нет информации о рейсах с остановкой на этой станции.",
        "no-threads-default": "Немає інформації щодо рейсів для цих параметрів пошуку.",
        "no-threads-for-filter": "За цим фільтром нічого не знайдено",
        "no-threads-suburban-arrival-on-all-days": "Немає інформації щодо приміських потягів (електричок), що прибувають на цю станцію.",
        "no-threads-suburban-arrival-on-date": function(params){return "Немає інформації щодо приміських потягів (електричок), що прибувають "+params.date+".";},
        "no-threads-suburban-departure-on-all-days": "Немає інформації щодо приміських потягів (електричок), що відправляються з цієї станції.",
        "no-threads-suburban-departure-on-date": function(params){return "Немає інформації щодо приміських потягів (електричок), що відправляються "+params.date+".";},
        "no-threads-train-arrival-on-all-days": "Немає інформації щодо потягів, що прибувають на цю станцію.",
        "no-threads-train-arrival-on-date": function(params){return "Немає інформації щодо потягів, що прибувають "+params.date+".";},
        "no-threads-train-departure-on-all-days": "Немає інформації щодо потягів, що відправляються із цієї станції.",
        "no-threads-train-departure-on-date": function(params){return "Немає інформації щодо потягів, що відправляються "+params.date+".";},
        "page-subtype-suburban": "Електрички",
        "page-subtype-tablo": "Все табло",
        "page-subtype-train": "Потяги",
        "popular-directions": "Популярні напрямки",
        "popular-directions-water": "Быстрый поиск маршрута",
        "print": "Роздрукувати",
        "schedule-for-print": function(params){return "Расписание на "+params.date;},
        "schedule-for-print-on-all-days": "Расписание на все дни",
        "schedule-on-all-days": "розклад на усі дні",
        "schedule-on-date": function(params){return "Розклад на "+params.date;},
        "schedule-on-time": function(params){return "Расписание с "+params.min+" до "+params.max;},
        "schedule-on-today": "Расписание на сегодня",
        "schedule-on-tomorrow": "Розклад на завтра",
        "schedule-suburban": "розклад приміських потягів (електричок)",
        "schedule-train": "розклад потягів далекого сполучення",
        "scheduleAllDays": "На усі дні",
        "scheduleToday": "Сьогодні",
        "scheduleTomorrow": "Завтра",
        "search-default": "Місто або станція",
        "search-plane": "Номер рейсу, місто або авіакомпанія",
        "search-station-header": "Поиск станции",
        "search-station-not-found": "По данному фильтру станций не найдено",
        "search-station-placeholder": "Остановка или населенный пункт",
        "search-suburban": "Місто, станція або номер електрички",
        "search-train": "Місто, станція або номер потягу",
        "show-all-bus-stations": "Все автовокзалы",
        "show-gone": function(params){return "Відображати ті, що відправилися ("+params.count+")";},
        "show-gone-arrival": function(params){return "Відображати ті, що прибули ("+params.count+")";},
        "show-gone-suburban": function(params){return "Відображати ті, що відправилися ("+params.count+" "+plural({"count":params.count,"one":"електричка","some":"електрички","many":"електричок"})+")";},
        "show-gone-suburban-arrival": function(params){return "Відображати ті, що прибули ("+params.count+" "+plural({"one":"електричка","some":"електрички","plural":"електричок"})+")";},
        "show-gone-train": function(params){return "Відображати ті, що відправилися ("+params.count+" "+plural({"count":params.count,"one":"поїзд","some":"поїзди","plural":"поїздів"})+")";},
        "show-gone-train-arrival": function(params){return "Відображати ті, що прибули ("+params.count+" "+plural({"count":params.count,"one":"поїзд","some":"поїзди","many":"поїздів"})+")";},
        "stops-everywhere": "З усіма зупинками",
        "stops-nonstop": "Без зупинок",
        "stops-stops": "Зупинки:",
        "terminal": function(params){return "Терминал "+params.terminalName;},
        "time": "Время",
        "title-bus": function(params){return "Расписание автобусов: "+params.title;},
        "title-suburban": function(params){return "Розклад електричок по "+params.titleDative;},
        "title-suburban-no-city": function(params){return "Розклад електричок: "+params.title;},
        "title-suburban-popular": function(params){return "Розклад електричок: "+params.title+" ("+params.cityName+")";},
        "title-suburban-popular-no-city": function(params){return "Розклад електричок: "+params.title;},
        "title-tablo": function(params){return "Расписание поездов и электричек по "+params.titleDative;},
        "title-tablo-no-city": function(params){return "Расписание поездов и электричек: "+params.title;},
        "title-tablo-popular": function(params){return "Расписание поездов и электричек: "+params.title+" ("+params.cityName+")";},
        "title-tablo-popular-no-city": function(params){return "Расписание поездов и электричек: "+params.title;},
        "title-train": function(params){return "Розклад потягів по "+params.titleDative;},
        "title-train-no-city": function(params){return "Розклад потягів: "+params.title;},
        "title-train-popular": function(params){return "Розклад потягів: "+params.title+" ("+params.cityName+")";},
        "title-train-popular-no-city": function(params){return "Розклад потягів: "+params.title;},
        "title-unknown": function(params){return "Розклад по "+params.titleDative;},
        "title-water": function(params){return params.title+": расписание теплоходов";},
        "to-arrival-train-link": function(params){return params.title+": прибытие поездов";},
        "to-departure-train-link": function(params){return params.title+": отправление поездов";},
        "to-station": function(params){return "До остановки: "+params.title;},
        "to-station-short": function(params){return "До остановки "+params.title;},
        "transport-link-text-suburban": "Розклад електричок",
        "transport-link-text-train": "Розклад потягів",
        "try-view-schedule": "Спробуйте переглянути: ",
        "type-bus": "Автовокзали",
        "type-plane": "Аеропорти",
        "type-train": "Вокзали та станції",
        "type-water": "Водный транспорт"
    }
});
