import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "station",
    data: {
        "aeroexpress": "Aeroekspress",
        "aeroexpress-text": function(params){return "Aeroekspress "+params.airportName;},
        "all-directions": "Barcha yoʻnalishlar",
        "all-terminals": "Все терминалы",
        "all-times": "Любое время",
        "arrival": "Kelish",
        "arrival-plane": "Uchib kelish",
        "city-stations": function(params){return "Stansiyalar "+params.cityTitleGenitive;},
        "date-arrival-all-days-plane": "Прилет, все дни",
        "date-arrival-all-days-train": "Прибытие, все дни",
        "date-departure-all-days-plane": "Вылет, все дни",
        "date-departure-all-days-train": "Отправление, все дни",
        "date-mobile-arrival-plane": function(params){return "Прилет "+params.date+", "+params.dayOfWeek;},
        "date-mobile-arrival-train": function(params){return "Прибытие "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-bus": function(params){return "Отправление "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-plane": function(params){return "Вылет "+params.date+", "+params.dayOfWeek;},
        "date-mobile-departure-train": function(params){return "Отправление "+params.date+", "+params.dayOfWeek;},
        "departure": "Ketish",
        "departure-plane": "Uchib ketish",
        "disclaimer-bus": function(params){return params.title+": расписание пригородных и междугородних автобусов на "+((params.whenSpecial=="today")?"сегодня":"")+((params.whenSpecial=="tomorrow")?"завтра":"")+((params.whenSpecial=="all-days")?"все дни":"")+(params.whenDate?(params.whenSpecial?", ":"")+params.whenDate:"")+". На странице можно отобразить только нужные вам рейсы: для этого введите в поле фильтра номер маршрута или станцию назначения.";},
        "disclaimer-bus-attention": "Внимание! В расписании показаны рейсы автобусов, доступные нашему сервису. Каких-то рейсов может не быть в расписании, потому что перевозчик не передал нам информацию о них. Кроме того, перевозчики не всегда сообщают об изменениях цен на проезд, поэтому советуем перед поездкой позвонить %%на автостанцию%% или перевозчику и уточнить детали.",
        "disclaimer-suburban": function(params){return " "+params.title+" stansiyasi boʻyicha elektr poyezdlarning "+params.year+" yil uchun "+params.date+" oʻzgarishlarni hisobga olgan jadvali. Yarim tundan keyin joʻnaydigan shahar atrofidagi poyezdlarning oʻzgarish sanalari va harakatlanish kunlari yangi sutkalarga tegishlidir.\nBarcha bekatlarni oʻz ichiga olgan elektr poyezdi harakatining batafsil marshruti bilan tanishish uchun reysni tanlang.";},
        "disclaimer-suburban-all-days": function(params){return params.title+" stansiyasi boʻyicha elektr poyezdlarning oʻzgarishlarni hisobga olgan jadvali.\nBarcha bekatlarni oʻz ichiga olgan elektr poyezdi harakatining batafsil marshruti bilan tanishish uchun reysni tanlang.";},
        "disclaimer-tablo": function(params){return "Расписание движения поездов дальнего следования и электричек от "+params.titleGenitive+" на "+params.year+" год с учетом изменений. Даты изменения и дни курсирования поездов, отправляющихся после полуночи, относятся к новым суткам. Чтобы узнать цену билета на поезда РЖД, выберите станции отправления и назначения.";},
        "disclaimer-tablo-title": function(params){return "Онлайн-табло по "+params.titleDative;},
        "disclaimer-tablo-title-popular": function(params){return "Онлайн-табло "+params.titleGenitive;},
        "disclaimer-train": function(params){return "Uzoq masofaga yuruvchi poyezdlarning "+params.titleGenitive+" dan "+params.year+" yil uchun oʻzgarishlarni hisobga olgan harakat jadvali. Yarim tundan keyin joʻnaydigan shahar atrofidagi poyezdlarning oʻzgarish sanalari va harakatlanish kunlari yangi sutkalarga tegishlidir.\nRTY poyezdlariga chipta narxlarini bilish uchun ketish va kelish stansiyalarini tanlang.";},
        "disclaimer-train-title": function(params){return params.titleDative+" boʻyicha onlayn jadval";},
        "disclaimer-train-title-popular": function(params){return params.titleGenitive+" onlayn jadvali.";},
        "disclaimer-water": function(params){return "Онлайн табло "+params.titleGenitive+" с расписанием теплоходов, паромов, речных трамвайчиков, катеров и другого водного транспорта на "+params.year+" год.";},
        "except": "кроме",
        "hide-gone": function(params){return "Ketganlarni yashirish ("+params.count+")";},
        "hide-gone-arrival": function(params){return "Kelganlarni yashirish ("+params.count+")";},
        "hide-gone-suburban": function(params){return "Ketganlarni yashirish ("+params.count+" "+plural({"count":params.count,"one":"ta elektr poyezd","some":"ta elektr poyezd","many":"ta elektr poyezd"})+")";},
        "hide-gone-suburban-arrival": function(params){return "Kelganlarni yashirish ("+params.count+" "+plural({"count":params.count,"one":"ta elektr poyezd","some":"ta elektr poyezd","many":"ta elektr poyezd"})+")";},
        "hide-gone-train": function(params){return "Ketganlarni yashirish("+params.count+" "+plural({"count":params.count,"one":"ta elektr poyezd","some":"ta elektr poyezd","many":"ta elektr poyezd"})+")";},
        "hide-gone-train-arrival": function(params){return "Kelganlarni yashirish ("+params.count+" "+plural({"count":params.count,"one":"ta elektr poyezd","some":"ta elektr poyezd","many":"ta elektr poyezd"})+")";},
        "informer-link": "Разместить расписание на своём сайте",
        "interval-thread-time": function(params){return "С "+params.beginTime+" до "+params.endTime;},
        "local-time-disclaimer": "Mahalliy vaqt koʻrsatilgan",
        "map-default-text": "Xaritada koʻrish",
        "more-directions": "Yana",
        "next": "далее",
        "no-info": "Yandex.Jadvalda bu stansiyada toʻxtaydigan reyslar haqida axborot mavjud emas.",
        "no-threads-bus": "У Яндекс.Расписаний нет информации о рейсах с остановкой на этой станции.",
        "no-threads-default": "Bu qidiruv parametrlari uchun reyslar haqida axborot mavjud emas.",
        "no-threads-for-filter": "Bu filtr boʻyicha hech narsa topilmadi",
        "no-threads-suburban-arrival-on-all-days": "Bu stansiyaga kelgan shahar atrofidagi poyezdlar (elektr poyezdlar) haqida hech qanday axborot mavjud emas.",
        "no-threads-suburban-arrival-on-date": function(params){return params.date+" stansiyasiga kelgan shahar atrofidagi poyezdlar (elektr poyezdlar) haqida hech qanday axborot mavjud emas.";},
        "no-threads-suburban-departure-on-all-days": "Bu stansiyadan ketadigan poyezdlar (elektr poyezdlar) haqida hech qanday axborot mavjud emas.",
        "no-threads-suburban-departure-on-date": function(params){return params.date+" stansiyasidan ketadigan shahar atrofidagi poyezdlar (elektr poyezdlar) haqida hech qanday axborot mavjud emas.";},
        "no-threads-train-arrival-on-all-days": "Bu stansiyaga keladigan poyezdlar haqida axborot mavjud emas.",
        "no-threads-train-arrival-on-date": function(params){return params.date+" stansiyasiga keladigan poyezdlar haqida axborot mavjud emas.";},
        "no-threads-train-departure-on-all-days": "Bu stansiyadan ketadigan poyezdlar haqida axborot mavjud emas.",
        "no-threads-train-departure-on-date": function(params){return " "+params.date+" stansiyasidan ketadigan poyezdlar haqida axborot mavjud emas.";},
        "page-subtype-suburban": "Elektr poezdlar",
        "page-subtype-tablo": "Все табло",
        "page-subtype-train": "Poyezdlar",
        "popular-directions": "Ommabop yoʻnalishlar",
        "popular-directions-water": "Быстрый поиск маршрута",
        "print": "Chop etish",
        "schedule-for-print": function(params){return "Расписание на "+params.date;},
        "schedule-for-print-on-all-days": "Расписание на все дни",
        "schedule-on-all-days": "barcha kunlar jadvali",
        "schedule-on-date": function(params){return "Kun jadvali: "+params.date;},
        "schedule-on-time": function(params){return "Расписание с "+params.min+" до "+params.max;},
        "schedule-on-today": "Расписание на сегодня",
        "schedule-on-tomorrow": "Ertangi kun jadvali",
        "schedule-suburban": "shahar atrofidagi poyezdlar jadvali (elektr poyezdlar)",
        "schedule-train": "uzoq masofaga yuradigan poyezdlar jadvali",
        "scheduleAllDays": "Barcha kunlar uchun",
        "scheduleToday": "Bugun",
        "scheduleTomorrow": "Ertaga",
        "search-default": "Shahar yoki stansiya",
        "search-plane": "Reys raqami, shahar yoki aviakompaniya",
        "search-station-header": "Поиск станции",
        "search-station-not-found": "По данному фильтру станций не найдено",
        "search-station-placeholder": "Остановка или населенный пункт",
        "search-suburban": "Shahar, stansiya yoki elektr poyezd raqami",
        "search-train": "Shahar, stansiya yoki poyezd raqami",
        "show-all-bus-stations": "Все автовокзалы",
        "show-gone": function(params){return "Ketganlarni koʻrsatish ("+params.count+")";},
        "show-gone-arrival": function(params){return "Kelganlarni koʻrsatish ("+params.count+")";},
        "show-gone-suburban": function(params){return "Ketganlarni koʻrsatish ("+params.count+" "+plural({"count":params.count,"one":"ta elektr poyezd","some":"ta elektr poyezd","many":"ta elektr poyezd"})+")";},
        "show-gone-suburban-arrival": function(params){return "Ketganlarni koʻrsatish ("+params.count+" "+plural({"count":params.count,"one":"ta elektr poyezd","some":"ta elektr poyezd","many":"ta elektr poyezd"})+")";},
        "show-gone-train": function(params){return "Ketganlarni koʻrsatish ("+params.count+" "+plural({"count":params.count,"one":"ta poyezd","some":"ta poyezd","many":"ta poyezd"})+")";},
        "show-gone-train-arrival": function(params){return "Kelganlarni koʻrsatish ("+params.count+" "+plural({"count":params.count,"one":"ta poyezd","some":"ta poyezd","many":"ta poyezd"})+")";},
        "stops-everywhere": "Barcha bekatlar bilan",
        "stops-nonstop": "Bekatlarsiz",
        "stops-stops": "Bekatlar:",
        "terminal": function(params){return "Терминал "+params.terminalName;},
        "time": "Время",
        "title-bus": function(params){return "Расписание автобусов: "+params.title;},
        "title-suburban": function(params){return "Elektr poyezdlar jadvali: "+params.titleDative;},
        "title-suburban-no-city": function(params){return "Elektr poyezdlar jadvali: "+params.title;},
        "title-suburban-popular": function(params){return "Elektr poyezdlar jadvali: "+params.title+" ("+params.cityName+")";},
        "title-suburban-popular-no-city": function(params){return "Elektr poyezdlar jadvali: "+params.title;},
        "title-tablo": function(params){return "Расписание поездов и электричек по "+params.titleDative;},
        "title-tablo-no-city": function(params){return "Расписание поездов и электричек: "+params.title;},
        "title-tablo-popular": function(params){return "Расписание поездов и электричек: "+params.title+" ("+params.cityName+")";},
        "title-tablo-popular-no-city": function(params){return "Расписание поездов и электричек: "+params.title;},
        "title-train": function(params){return "Poyezdlar jadvali: "+params.titleDative;},
        "title-train-no-city": function(params){return "Poyezdlar jadvali: "+params.title;},
        "title-train-popular": function(params){return "Poyezdlar jadvali: "+params.title+" ("+params.cityName+")";},
        "title-train-popular-no-city": function(params){return "Poyezdlar jadvali: "+params.title;},
        "title-unknown": function(params){return "Quyidagi boʻyicha jadval: "+params.titleDative;},
        "title-water": function(params){return params.title+": расписание теплоходов";},
        "to-arrival-train-link": function(params){return params.title+": прибытие поездов";},
        "to-departure-train-link": function(params){return params.title+": отправление поездов";},
        "to-station": function(params){return "До остановки: "+params.title;},
        "to-station-short": function(params){return "До остановки "+params.title;},
        "transport-link-text-suburban": "Elektr poyezdlar jadvali",
        "transport-link-text-train": "Poyezdlar jadvali",
        "try-view-schedule": "Quyidagilar bilan tanishing: ",
        "type-bus": "Avtovokzallar",
        "type-plane": "Aeroportlar",
        "type-train": "Vokzallar va stansiyalar",
        "type-water": "Водный транспорт"
    }
});
