import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "thread",
    data: {
        "advance": function(params){return "опережение на "+params.minutes+" мин";},
        "advance-from-to": function(params){return "опережение на "+params.minutesFrom+"-"+params.minutesTo+" мин";},
        "arrival-time": "Прибытие",
        "arrival-time-short": "Приб.",
        "arrived-advance": function(params){return "прибыл с опережением на "+params.minutes+" мин";},
        "arrived-in-time": "прибыл по расписанию",
        "arrived-late": function(params){return "прибыл с опозданием на "+params.minutes+" мин";},
        "bus-title": function(params){return "Автобус "+params.title;},
        "carrier": "Перевозчик",
        "class-business": "в бизнес-классе",
        "class-common": "в общем вагоне",
        "class-compartment": "в купе",
        "class-economy": "в эконом-классе",
        "class-platzkarte": "в плацкартном вагоне",
        "class-sitting": "в сидячем вагоне",
        "class-suburban": "по полному тарифу",
        "class-suite": "в СВ",
        "contacts-of-carrier": "Контакты перевозчика",
        "current-schedule": "Данный вариант расписания действует",
        "departure-time": "Отправл.",
        "departure-time-long": "Отправление",
        "departure-time-short": "Отпр.",
        "description-one-stop": function(params){return "По маршруту поезд делает  одну остановку: "+params.longestStation1Name+" – "+params.longestStation1Time+". ";},
        "description-stops": function(params){return "По маршруту поезд делает "+params.stopsCount+" "+plural({"count":params.stopsCount,"one":"остановку","some":"остановки","many":"остановок"})+". Самые долгие стоянки: "+params.longestStation1Name+" – "+params.longestStation1Time+", "+params.longestStation2Name+" – "+params.longestStation2Time+". ";},
        "description-technical-stop-stations": "Обратите внимание, часть станций на пути следования поезда – технические, отмечены *, купить билет до этих станций невозможно. ",
        "description-text": function(params){return "Поезд отправляется со станции "+params.stationFrom+" в "+params.departureFrom+" по местному времени. Прибывает на станцию "+params.stationTo+" в "+params.arrivalTo+".\n"+params.stopsDescription+params.technicalStopDescription+"Общее время в пути – "+params.totalTime+".";},
        "description-text-with-prices": function(params){return "Поезд отправляется со станции "+params.stationFrom+" в "+params.departureFrom+" по местному времени. Прибывает на станцию "+params.stationTo+" в "+params.arrivalTo+".\n"+params.stopsDescription+params.technicalStopDescription+"Общее время в пути – "+params.totalTime+". Стоимость билетов на поезд "+params.number+" "+params.title+" начинается "+params.pricesToTypes+".";},
        "description-title": function(params){return "Маршрут и расписание поезда "+params.number+" "+params.title;},
        "display-next-stations": "Показать следующие станции",
        "display-prev-stations": "Показать предыдущие станции",
        "expected-in-time": "ожидается по расписанию",
        "few-seats": "места",
        "hide-detailed-schedule": "Скрыть варианты расписания",
        "hide-next-stations": "Скрыть следующие станции",
        "hide-prev-stations": "Скрыть предыдущие станции",
        "in-the-way": "В пути",
        "in-time": "по расписанию",
        "late": function(params){return "опоздание на "+params.minutes+" мин";},
        "late-from-to": function(params){return "опоздание на "+params.minutesFrom+"-"+params.minutesTo+" мин";},
        "map-button": "Карта маршрута",
        "one-seat": "место",
        "other-today-threads-title": "Другие варианты в этот день",
        "possible-delay": "возможно опоздание",
        "possible-delay-from": function(params){return "возможно опоздание более "+params.minutes+" мин";},
        "possible-delay-from-to": function(params){return "возможно опоздание на "+params.minutesFrom+"-"+params.minutesTo+" мин";},
        "possible-delay-to": function(params){return "возможно опоздание до "+params.minutes+" мин";},
        "price-in-type-last": function(params){return "и "+params.priceInType;},
        "prices-and-places": "Цены и места",
        "print-the-route": "Распечатать",
        "related-threads-title-basic-train": "Основной поезд",
        "related-threads-title-no-change-wagon": "Беспересадочные вагоны",
        "related-threads-title-other-no-change-wagon": "Другие беспересадочные вагоны",
        "return-to-rasp": "Вернуться к расписанию",
        "schedule-basic": "Основное расписание",
        "schedule-basic-current": "Данное основное расписание",
        "schedule-basic-other": "Другие основные расписания",
        "schedule-cancel": "Отменен на полном маршруте",
        "schedule-change": "Изменения",
        "schedule-change-current": "Данное изменение",
        "schedule-change-other": "Другие изменения",
        "schedule-current": "Данное расписание",
        "schedule-for-month": "Расписание на месяц",
        "schedule-non-context": function(params){return "Варианты расписания, не проходящие через "+params.stationFromTitle+" либо "+params.stationToTitle;},
        "schedule-other": "Другие варианты расписания",
        "select-and-buy-ticket": "Выбрать и купить билеты",
        "show-detailed-schedule": "Показать варианты расписания",
        "station": "Станция",
        "stay-time": "Стоянка",
        "technical-stop": "техническая остановка, купить билет до этой станции невозможно.",
        "tickets-for": function(params){return "Билеты на маршрут "+params.title;},
        "tickets-for-from-to": function(params){return "Билеты на маршрут "+params.titleFrom+" – "+params.titleTo;},
        "time-in-the-way": "Время в пути",
        "timezone-change": function(params){return "Местное время "+params.capitalShortName+" "+params.timezoneDifference+" ч";},
        "timezone-change-short": function(params){return params.capitalShortName+" "+params.timezoneDifference+" ч";},
        "title-bus": function(params){return "Розклад автобуса "+params.title;},
        "title-helicopter": function(params){return "Расписание вертолёта "+params.number+" "+params.title;},
        "title-plane": function(params){return "Розклад літака "+params.number+" "+params.title;},
        "title-prices": "Наличие мест и цены",
        "title-prices-bus": "Цены",
        "title-river": function(params){return "Розклад теплохода "+params.title;},
        "title-sea": function(params){return "Розклад теплохода "+params.title;},
        "title-suburban": function(params){return "Розклад електрички "+params.number+" "+params.title;},
        "title-thread-icon": "маршрут рейсу",
        "title-train": function(params){return "Розклад поїзда "+params.number+" "+params.title;},
        "title-water": function(params){return "Розклад теплохода "+params.title;},
        "transition": "Пересадка",
        "zero-or-many-seats": "мест"
    }
});
