import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "time",
    data: {
        "approximate": "шамамен алынған уақыт",
        "days": function(params){return params.count+plural({"count":params.count,"one":"күн","some":"күн","many":"күн"});},
        "days-short": function(params){return params.count+" күн";},
        "departing-now": "қазір жөнелтіледі",
        "duration-from": "бастап",
        "hours": function(params){return params.count+plural({"count":params.count,"one":"сағат","some":"сағат","many":"сағат"});},
        "hours-short": function(params){return params.count+" сағ";},
        "in-time": function(params){return params.time+" уақыттан кейін";},
        "interval": function(params){return params.start+" бастап "+params.end+" дейін";},
        "minutes": function(params){return params.count+plural({"count":params.count,"one":"минут","some":"минут","many":"минут"});},
        "minutes-short": function(params){return params.count+" мин";},
        "on-way": "жолда",
        "weeks": function(params){return params.count+plural({"count":params.count,"one":"апта","some":"апта","many":"апта"});},
        "weeks-short": function(params){return params.count+" апта";}
    }
});
