import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "time",
    data: {
        "approximate": "примерное время",
        "days": function(params){return params.count+" "+plural({"count":params.count,"one":"день","some":"дня","many":"дней"});},
        "days-short": function(params){return params.count+" дн";},
        "departing-now": "отправляется сейчас",
        "duration-from": "от ",
        "hours": function(params){return params.count+" "+plural({"count":params.count,"one":"час","some":"часа","many":"часов"});},
        "hours-short": function(params){return params.count+" ч";},
        "in-time": function(params){return "через "+params.time;},
        "interval": function(params){return "c "+params.start+" до "+params.end;},
        "minutes": function(params){return params.count+" "+plural({"count":params.count,"one":"минута","some":"минуты","many":"минут"});},
        "minutes-short": function(params){return params.count+" мин";},
        "on-way": "в пути",
        "weeks": function(params){return params.count+" "+plural({"count":params.count,"one":"неделя","some":"недели","many":"недель"});},
        "weeks-short": function(params){return params.count+" нед.";}
    }
});
