import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "time",
    data: {
        "approximate": "приблизний час",
        "days": function(params){return params.count+" "+plural({"count":params.count,"one":"день","some":"дні","many":"днів"});},
        "days-short": function(params){return params.count+" дн";},
        "departing-now": "відправляється зараз",
        "duration-from": "від ",
        "hours": function(params){return params.count+" "+plural({"count":params.count,"one":"година","some":"години","many":"годин"});},
        "hours-short": function(params){return params.count+" год";},
        "in-time": function(params){return "через "+params.time;},
        "interval": function(params){return "із "+params.start+" до "+params.end;},
        "minutes": function(params){return params.count+" "+plural({"count":params.count,"one":"хвилина","some":"хвилини","many":"хвилин"});},
        "minutes-short": function(params){return params.count+" хв";},
        "on-way": "у дорозі",
        "weeks": function(params){return params.count+" "+plural({"count":params.count,"one":"тиждень","some":"тижні","many":"тижнів"});},
        "weeks-short": function(params){return params.count+" тиж.";}
    }
});
