import plural from "../_utils/plural";
import exporter from "../_utils/exporter";

export default exporter({
    name: "time",
    data: {
        "approximate": "taxminiy vaqt",
        "days": function(params){return params.count+" "+plural({"count":params.count,"one":"kun","some":"kun","many":"kun"});},
        "days-short": function(params){return params.count+" kun";},
        "departing-now": "hozir joʻnaydi",
        "duration-from": "quyidagidan:",
        "hours": function(params){return params.count+" "+plural({"count":params.count,"one":"soat","some":"soat","many":"soat"});},
        "hours-short": function(params){return params.count+" soat";},
        "in-time": function(params){return "orqali "+params.time;},
        "interval": function(params){return " "+params.start+" dan quyidagigacha "+params.end;},
        "minutes": function(params){return params.count+" "+plural({"count":params.count,"one":"daqiqa","some":"daqiqa","many":"daqiqa"});},
        "minutes-short": function(params){return params.count+" daq";},
        "on-way": "yoʻlda",
        "weeks": function(params){return params.count+" "+plural({"count":params.count,"one":"hafta","some":"hafta","many":"hafta"});},
        "weeks-short": function(params){return params.count+" hafta";}
    }
});
