import {Application, Response, NextFunction} from 'express';

import IExpressRequest from './IExpressRequest';

type RequestHandler = (
    req: IExpressRequest,
    res: Response,
    next: NextFunction,
) => void;

// Наше приложение на сервере после того, как отработают мидлевары server/oldMiddleware.js
type ExpressApplication = Application & {
    get(path: string, handler: RequestHandler): void;
};

// eslint-disable-next-line no-undef
export default ExpressApplication;
