import AdFoxPosition from './components/adFox/AdFoxPosition';
import AdFoxType from './components/adFox/AdFoxType';
import IAdFoxCreateError from './IAdFoxCreateError';

export default interface IAdfoxParams {
    ownerId: number;
    containerId: string;
    params: {
        pp: AdFoxPosition;
        ps: string; // Это свойство содержит SITE_ID
        p2: AdFoxType;
    };

    onError?: (error: IAdFoxCreateError) => void; // Вызывается, если в ходе выполнения запроса была получена сетевая ошибка (например, 404) или же код баннера содержит синтаксическую ошибку.
    onStub?: () => void; // Вызывается, когда сервер вернул заглушку (системный код), контейнер остался пустым.
}
