import {Request} from 'express';
import {Span} from 'opentracing';
import {ABTInfo} from '@yandex-int/abt';

import ICookie from './cookies/ICookie';
import Tld from './Tld';
import IStateFlags from './state/flags/IStateFlags';
import IAbtFlags from './state/flags/IAbtFlags';
import IMetaLink from './lib/meta/IMetaLink';

// Объект запроса после прохождения всех серверных middleware
export default interface IExpressRequest extends Request {
    isExpressRequest: boolean;
    tld: Tld;
    nonce: string;
    cookies: ICookie;
    hostname: string;
    fullUrl: string;
    uatraits: {
        // Описание всех полей тут: https://a.yandex-team.ru/arcadia/frontend/packages/yandex-useragent
        OSFamily?: string;
        OSVersion?: string;
        BrowserName?: string;
        BrowserVersion?: string;
        BrowserBase?: string;
        BrowserBaseVersion?: string;
        isMobile?: boolean;
    };
    isBot: boolean;
    isSearchBot: boolean;
    requestId: string;
    originalUrl: string;
    rootSpan: Span; // Корневой спан для трассировки запроса через Jaeger
    hasYandexUid: boolean;
    flags: IStateFlags;
    aborted: boolean; // Признак того, что запрос завершен (например, пользователь закрыл вкладку в браузере). На самом деле это свойство должно быть объявлено в тайпинга для ноды в классе IncomingMessage, но его там нет в текущей версии
    backendAltLinks: {
        // Похоже на какое-то легаси
        touch: IMetaLink;
    };
    altLinks: IMetaLink[];

    abtInfo?: ABTInfo<Record<string, string | boolean> & IAbtFlags>;
    isTouchDomain?: boolean;
    mockParams?: object;
    mock?: {
        getNow(): string;
    };
    networkTraits?: {
        isYandexNetwork: boolean;
    };
    jaegerDebugId?: string; // Если задан, то трассировка данного запроса точно попадет в Jaeger
}
