import Req from './router/Req';

interface ITags {
    http?: 500; // http-код ответа приложения
}

export type TLoggerLevel = 'info' | 'debug' | 'warning' | 'error' | 'fatal';

interface IErrorOptions {
    req?: Req;
    stackTrace?: string; // Можно перетереть stack ошибки
    message?: string; // Дополнительная информация об ошибке
    tags?: ITags;
    level: TLoggerLevel;
}

export default interface ILogger {
    info: (path: string, message: string) => void;
    error: (
        path: string,
        error: Error | string,
        options?: IErrorOptions,
    ) => void;
}
